
## Overview
This repository contains the code for our ICLR submission to generate LDS via NeuroLDS.

## Key files & scripts
- `scripts/models.py` — Main model definition (NeuroLDS).
- `scripts/main.py` — Create/generate sequences; trains/evaluates NeuroLDS.
- `scripts/utils.py` — Aid/utility functions (discrepancy losses, seeding, I/O, plotting).
- `scripts/hypertuning.py` — Hyperparameter optimization via Optuna.
- `scripts/smoke_test.sh` — Sanity check; run to verify the setup works end-to-end.

## Installation
```bash
python3 -m venv .venv && source .venv/bin/activate
pip install -r requirements.txt
```

## Quick check
Run the smoke test to verify that everything is set up correctly:
```bash
cd scripts
bash smoke_test.sh
```
