#!/bin/bash

export range=${1:-2000_4000}
export target=target_words_$range
export rootdir=$(dirname $(readlink -ef $0))/../
export SHELL=/bin/bash

export word_cost=${2:-1}
export bit_cost=${3:-1}

proj=$(date +%Y%m%d%H%M)paraphrase-pddl

submit="jbsub -queue x86_1h -cores 1 -mem 16g -proj $proj"

task (){
    problem=$target-$word_cost-$bit_cost/$2/$(basename $1).soft.pddl
    mkdir -p $target-$word_cost-$bit_cost/$2
    # names adds dels embedding word output
    lisp/generate-paraphrase-soft-problem.ros \
        $1/action_name_0_None.csv \
        $1/action_add_0_None.csv  \
        $1/action_del_0_None.csv  \
        $(jq .embedding $1/hyper.json) \
        $2 \
        $problem $word_cost $bit_cost
}
export -f task

parallel --verbose -j 1 $submit task \
         ::: selected/* \
         :::: $target.csv
