#!/bin/bash -x

export mode=${1:-soft}
export source_range=${2:-0_2000}
export target_range=${3:-2000_4000}
export target=target_words_$target_range
export rootdir=$(dirname $(readlink -ef $0))/../
export SHELL=/bin/bash
export word_cost=${4:-1}
export bit_cost=${5:-1}

proj=$(date +%Y%m%d%H%M)pddl5-softfd

submit="jbsub -queue x86_6h -cores 1 -mem 16g -proj $proj"

task (){
    domain=$1/domain_${mode}_${source_range}.pddl
    problem=target_words_$target_range-$word_cost-$bit_cost/$2/$(basename $1).${mode}.pddl
    heur="$3"
    heur_name=$(echo "$3" | sed "s/[ (){}]/-/g;s/--\(search\|alias\|evaluator\)//g;s/--/-/g")
    problem2_name=$(echo $(basename $1).${mode}.pddl.${source_range}.$heur_name | head -c 245)
    problem2=target_words_$target_range-$word_cost-$bit_cost/$2/$problem2_name

    joblog=$problem2.joblog
    joberr=$problem2.joberr
    exec > $joblog 2> $joberr

    if ! [ -e $problem ]
    then
        echo "Problem file does not exist : $problem" >&2
        exit 1
    fi
    
    if ! grep -q :domain $problem
    then
        echo "Problem file is missing :domain entry : $problem" >&2
        exit 1
    fi
    
    echo "################################################################"
    echo metadata:
    echo inputs  :
    echo domain  : $domain
    echo problem : $problem
    echo link    : $problem2
    echo "################################################################"

    problem=$(readlink -ef $problem)
    domain=$(readlink -ef $domain)
    problem2=$(readlink -ef $problem2)
    ln -s $problem $problem2
    trap "rm -v $problem2" EXIT
    
    cd $rootdir
    echo $PWD

    if (echo "$heur" | grep -q -- "--\(alias\|search\|evaluator\)")
    then
        helper/fd-latest.sh "$heur" $problem2 $domain
    else
        helper/others.sh $heur $problem2 $domain
    fi
}
export -f task

LAMA="--alias seq-sat-lama-2011"
LAMA_NONUNIT="--evaluator hlm1=lmcount(lm_rhw(reasonable_orders=true),transform=adapt_costs(one),pref=true) --evaluator hff1=ff(transform=adapt_costs(one)) --evaluator hlm2=lmcount(lm_rhw(reasonable_orders=true),transform=adapt_costs(plusone),pref=true) --evaluator hff2=ff(transform=adapt_costs(plusone)) --search iterated([lazy_greedy([hff1,hlm1],preferred=[hff1,hlm1],cost_type=one,reopen_closed=false),lazy_greedy([hff2,hlm2],preferred=[hff2,hlm2],reopen_closed=false),lazy_wastar([hff2,hlm2],preferred=[hff2,hlm2],w=5),lazy_wastar([hff2,hlm2],preferred=[hff2,hlm2],w=3),lazy_wastar([hff2,hlm2],preferred=[hff2,hlm2],w=2),lazy_wastar([hff2,hlm2],preferred=[hff2,hlm2],w=1)],repeat_last=true,continue_on_fail=true)"
ITERATED_LAZY_FF="--evaluator h=ff() --search iterated([lazy_greedy([h]),lazy_wastar([h],w=10),lazy_wastar([h],w=5),lazy_wastar([h],w=3),lazy_wastar([h],w=2),lazy_wastar([h],w=1),astar(h)])"
ITERATED_EAGER_FF="--evaluator h=ff() --search iterated([eager_greedy([h]),eager_wastar([h],w=10),eager_wastar([h],w=5),eager_wastar([h],w=3),eager_wastar([h],w=2),astar(h)])"

parallel --verbose echo "$submit 'task {}'" \
         ::: selected/* \
         :::: target_words_$target_range.csv \
         ::: "$ITERATED_EAGER_FF" \
         "$LAMA" \
    | sort -R | parallel

