#!/bin/bash

if [ -z "$*" ]
then
    dirs=.
    dir=.
else
    dirs="$@"
    dir=$1
fi

SHELL=/bin/bash

tofile (){
    tmp=$(mktemp)
    $@ > $tmp
    echo $tmp
}


task (){
    count1=0
    count2=0
    for line in $1/*.plan*
    do
        length=$(grep -v % $line | grep -v cost | wc -l)
        if [ $length -gt 0 ]
        then
            let "count1 += 1"
        fi
        if [ $length -gt 1 ]
        then
            let "count2 += 1"
        fi
    done
    echo "$count1 $count2"
}
export -f task


files=$(tofile ls $dir ; for d in $dirs ; do tofile parallel -k task ::: $d/*/ ; done)

paste $files | column -t
rm $files
