#!/usr/bin/awk -f


BEGIN {
    match(ARGV[1],/(.*)\/(.*)\/(.*)/,arr)
    word           = arr[2]
    filename       = arr[3]
    match(filename,/(.*)\.(.*)\.(.*)\.(.*)\.(.*)\.(.*)/,arr)
    model   = arr[1]
    if (model == "CBOW_BTL_Sequential-0f338df683ac64ee6771d25047de22da"){
        embedding = 1000
    }
    if (model == "CBOW_BTL_Sequential-920379b95fa08aa3c26ff80446ceb1ff"){
        embedding = 500
    }
    if (model == "CBOW_BTL_Sequential-5897474224791aa750466b4c36a77693"){
        embedding = 200
    }
    
    domain  = arr[4]
    planner = arr[5]
    translate      = 14400
    initialization = 0
    plannum = -1
}

# Done! [41.640s CPU, 42.502s wall-clock]
/^Done!/{
    sub(/s/,"",$4)
    translate=$4
    initialization = 14400
}

# Building successor generator...done! [t=2662.87s]
/^Building successor generator...done!/{
    match($4,/\[t=([0-9]*\.[0-9]*)s\]/,arr)
    initialization=translate+arr[1]
}


# Actual search time: 2.76341s [t=2665.63s]
/Actual search time:/ {
    sub(/s/,"",$4)
    actual=$4
    match($5,/\[t=([0-9]*\.[0-9]*)s\]/,arr)
    elapsed=translate+arr[1]
}



/Plan length:/{
    len=$3
}
/Plan cost:/{
    cost=$3
}
/Expanded [0-9]+ state\(s\)./{
    expanded=$2
}
/Evaluated [0-9]+ state\(s\)./{
    evaluated=$2
}
/Generated [0-9]+ state\(s\)./{
    generated=$2
}
/Dead ends: [0-9]+ state\(s\)./{
    deadend=$3
}
/Solution found - keep searching/{
    plannum += 1
    print(word,embedding,domain,planner,plannum,translate,initialization,actual,elapsed,len,cost,expanded,evaluated,generated,deadend)
}

END {
    if (plannum==-1){
        print(word,embedding,domain,planner,plannum,translate,initialization,actual,elapsed,len,cost,expanded,evaluated,generated,deadend)
    }
}
