#!/bin/bash

export SHELL=/bin/bash

range="$@"
range=${range:-0_2000}

proj=$(date +%Y%m%d%H%M)pddl1

submit="jbsub -queue x86_1h -cores 1 -mem 16g -proj $proj"

task (){
    lisp/generate-base-domain.ros \
        $1/action_name_$2.csv \
        $1/action_add_$2.csv  \
        $1/action_del_$2.csv  \
        $1/domain_base_$2.pddl
}
export -f task

parallel --verbose -j 1 $submit task \
         ::: selected/* \
         ::: $range
