
import torch
import numpy as np
import subprocess
from collections import Counter

def to_csv(model,data,topk_include=None,topk_exclude=0):
    print("computing effects...")
    dels = model.word_effects[0].long()
    adds = model.word_effects[1].long()
    names = data._idx_to_word
    
    # If the argument is omitted or None, most_common() returns all elements in the counter.
    topk_to_include = Counter(dict(data.vocab.most_common(topk_include))) # e.g. rare words
    topk_to_exclude = Counter(dict(data.vocab.most_common(topk_exclude))) # e.g. common words like "a", "the"
    selected = (topk_to_include - topk_to_exclude).most_common()
    idxs = np.array([ data.word_to_idx(word) for word, count in selected if len(word) > 2 and word != "<unk>"])

    dels        = dels[idxs]
    adds        = adds[idxs]
    names       = names[idxs]
    del_path    = model.local(f"action_del_{topk_exclude}_{topk_include}.csv")
    add_path    = model.local(f"action_add_{topk_exclude}_{topk_include}.csv")
    name_path   = model.local(f"action_name_{topk_exclude}_{topk_include}.csv")
    
    print(f"writing to {add_path}...")
    with open(add_path, 'wb') as f:
        np.savetxt(f,adds,"%d")
    print(f"writing to {del_path}...")
    with open(del_path, 'wb') as f:
        np.savetxt(f,dels,"%d")
    print(f"writing to {name_path}...")
    with open(name_path, 'wb') as f:
        np.savetxt(f,names,"%s", encoding='utf8')

