import typing as _t
from pathlib import Path as _Path
from .base import ReflectionBase
from .data import ReflectiveSample, ReflDataCollector, ReflSFTDataModule
from ..task import ReasoningTask


Approach = _t.Literal["self-verify"]


def _not_supported_approach(key):
    supported = getattr(Approach, "__args__")
    supported = ', '.join(map(repr, supported))
    return NotImplementedError(f"\"{key}\" is not a supported reflection. The supported are: {supported}")


def get_reflection_class(key: Approach | None) -> type[ReflectionBase]:
    if key is None:
        from .base import NoReflection
        return NoReflection
    elif key == "self-verify":
        # from .revise_error import ErrorReflection
        from .self_verify import SelfVerify
        return SelfVerify
    else:
        raise _not_supported_approach(key)


def make_refletion_datamodule(
    approach: Approach,
    data_path: _Path | str,
    task: ReasoningTask | None = None,
    /, **kwargs
) -> ReflSFTDataModule:
    from .self_verify import SVReflSFTDataModule

    if approach == "self-verify":
        return SVReflSFTDataModule(data_path, **kwargs, task=task)
    else:
        raise _not_supported_approach(approach)


class param:

    @staticmethod
    def self_verify_data(
        seed: int = 42,
        num_workers: int = 4,
        tolerance: float = 0,
        decay: float = 1,
        temperature: float = 1,
        non_reflective_data: _t.Literal[False, "file", "task"] | dict = False,
        reflection_label: _t.Literal["weight", "binary", "detailed"] | None = "weight",
        reflection_frequency: float = 1,
        include_revision_examples: _t.Literal[False] | int = False,
        max_revised_attempts: int = 0,
        use_weighted_sampler: bool = False,
    ):
        return locals()
