import abc
from typing import ClassVar
from core.tokenization import Vocabulary
from ..reasoners import GenerativeReasoner
from ..task import ReasoningTask


class ReflectionBase(abc.ABC):

    required_vocab: ClassVar[Vocabulary] = Vocabulary()
    task: ReasoningTask | None = None

    def convert_reasoner[T: type[GenerativeReasoner]](self, cls: T) -> T:
        """
        Convert a generative reasoner to a reflective one. Optionally this may require task-specific information.
        """
        raise NotImplementedError


class NoReflection(ReflectionBase):

    def convert_reasoner[T: type[GenerativeReasoner]](self, cls: T) -> T:
        return cls
