import typing
import enum
from pathlib import Path


class Symbol(enum.StrEnum):
    
    begin = '<reflect>'
    revise = '<revise>'
    reject = '</reflect:X>'
    pass_ = '<pass>'
    accept = '</reflect:?>'
    failure = '<failure>'


type BinaryVerifier = typing.Callable[[str, str], bool]
type PathLike = Path | str


@typing.runtime_checkable
class BinaryVerifiable(typing.Protocol):
    """The reasoning context can be verified in a binary mode"""
        
    def binary_verifier(self) -> typing.Callable[[str, str], bool]:
        """
        The binary verfier the checks a context `(prompt, output)`. It returns
        a boolean value signifying the correctness of the context.
        """
        raise NotImplementedError


@typing.runtime_checkable
class DetailVerifiable(typing.Protocol):
    """The reasoning context can be verified in a detail str."""

    def detail_verifier(self, true: str, false: str) -> typing.Callable[[str, str], str]:
        """
        The detail verfier the checks a context `(prompt, output)` in detail. It returns
        a string containing a series of `true` or `false` markers.
        """

        raise NotImplementedError


@typing.runtime_checkable
class RejectRatioEvaluated(typing.Protocol):
    """The rejection ration of reflection can be restored from evaluation results."""

    def reject_ratio_map(self, eval_results: typing.Any) -> typing.Callable[..., float]:
        return lambda **references: 0.5
