import random
import copy


def is_valid(board, row, col, num):
    if num in board[row]:
        return False
    for r in range(9):
        if board[r][col] == num:
            return False
    start_row, start_col = 3 * (row // 3), 3 * (col // 3)
    for r in range(start_row, start_row+3):
        for c in range(start_col, start_col+3):
            if board[r][c] == num:
                return False
    return True

def find_empty(board):
    for r in range(9):
        for c in range(9):
            if board[r][c] == 0:
                return (r, c)
    return None

def generate_full_board(board):
    empty = find_empty(board)
    if not empty:
        return True  # 棋盘已填满
    row, col = empty
    numbers = list(range(1, 10))
    random.shuffle(numbers)
    for num in numbers:
        if is_valid(board, row, col, num):
            board[row][col] = num
            if generate_full_board(board):
                return True
            board[row][col] = 0
    return False

def count_solutions(board):
    empty = find_empty(board)
    if not empty:
        return 1
    row, col = empty
    count = 0
    for num in range(1, 10):
        if is_valid(board, row, col, num):
            board[row][col] = num
            count += count_solutions(board)
            if count > 1:
                board[row][col] = 0
                return count
            board[row][col] = 0
    return count


def remove_numbers(board, clues):
    # 计算已填的数字数量
    cells = [(r, c) for r in range(9) for c in range(9)]
    random.shuffle(cells)
    
    # 目前已给数字的数量
    current_clues = 81
    
    for row, col in cells:
        if current_clues <= clues:
            break
        # 暂时保存原来的数字
        backup = board[row][col]
        board[row][col] = 0

        board_copy = copy.deepcopy(board)
        if count_solutions(board_copy) != 1:
            board[row][col] = backup
        else:
            current_clues -= 1


def generate_sudoku_puzzle(guess_num = 10) -> str:

    clues = 81 - guess_num
    # clues = clues_map.get(difficulty, 30)
    
    board = [[0 for _ in range(9)] for _ in range(9)]
    if not generate_full_board(board):
        raise Exception("无法生成完整棋盘")
    
    # full_solution = copy.deepcopy(board)
    
    remove_numbers(board, clues)

    board_str = board2str(board)
    
    return board_str


def board2str(board) -> str:
    board_str = ""
    for row in board:
        for num in row:
            if num == 0:
                board_str += "."
            else:
                board_str += str(num)
    return board_str


def print_board(board):
    for r in range(9):
        line = ""
        for c in range(9):
            val = board[r][c]
            if val == 0:
                line += ". "
            else:
                line += str(val) + " "
            if (c+1) % 3 == 0 and c < 8:
                line += "| "
        print(line)
        if (r+1) % 3 == 0 and r < 8:
            print("- "*11)




if __name__ == "__main__":
    board = [[0 for _ in range(9)] for _ in range(9)]
    generate_full_board(board)
    print_board(board)
    # puzzle, solution = generate_sudoku_puzzle(10)
    # print("生成的谜题：")
    # print_board(puzzle)
    # print("\n完整解答：")
    # print_board(solution)
