#!/bin/bash

source /opt/rh/devtoolset-7/enable

export NGPUS=2

# Load params from args
export MODEL=$1
export TRAIN_TASK=$2
export TEST_TASK=$3
export LR=$4
export EPOCHS=$5
export PORT=$6
export SAM=$0

echo "MODEL=$MODEL"
echo "TRAIN_TASK=$TRAIN_TASK"
echo "TEST_TASK=$TEST_TASK"
echo "LR=$LR"
echo "EPOCHS=$EPOCHS"
echo "PORT=$PORT"
echo "SAM=$SAM"

time accelerate launch --config_file configs/default_accelerate_config.yaml --num_processes $NGPUS --main_process_port $PORT \
    tune_accelerate.py -v \
    --model $MODEL \
    --learning_rate $LR \
    --dropout 0 \
    --ngpus $NGPUS \
    --nepochs $EPOCHS \
    --weight_decay 0 \
    --warmup_ratio 0.03 \
    --max_length 512 \
    --batch_size 8 \
    --train_tasks $TRAIN_TASK \
    --test_tasks $TEST_TASK \
    --save \
    --sam 0
