#!/bin/bash

source /opt/rh/devtoolset-10/enable

export TRANSFORMERS_CACHE='/data/private_models/xx_models/huggingface'


export reward_model=$1
export reward_checkpoint_path=$2
export gold_model=$3
export gold_checkpoint_path_1=$4
export gold_checkpoint_path_2=$5
export N=$6
export num_steps=$7
export eval_steps=$8
export num_optim_tokens=$9
export batch_size=${10}
export one_prompt=${11}
export output_file=${12}
export input_file=${13}
export lr=${14}
export pez_mode=${15}

echo "reward_model: $reward_model"
echo "reward_checkpoint_path: $reward_checkpoint_path"
echo "gold_model: $gold_model"
echo "gold_checkpoint_path_1: $gold_checkpoint_path_1"
echo "gold_checkpoint_path_2: $gold_checkpoint_path_2"
echo "N: $N"
echo "num_steps: $num_steps"
echo "eval_steps: $eval_steps"
echo "num_optim_tokens: $num_optim_tokens"
echo "batch_size: $batch_size"
echo "one_prompt: $one_prompt"
echo "output_file: $output_file"
echo "input_file: $input_file"
echo "pez_mode: $pez_mode"
echo "lr: $lr"

if [[ ! -d $(dirname $output_file) ]]; then
    mkdir -p $(dirname $output_file)
fi

python ../attack_pez_whitebox.py \
    --reward_model $reward_model \
    --reward_checkpoint_path $reward_checkpoint_path \
    --gold_model $gold_model \
    --gold_checkpoint_path_1 $gold_checkpoint_path_1 \
    --gold_checkpoint_path_2 $gold_checkpoint_path_2 \
    --input_file $input_file \
    --N $N \
    --num_steps $num_steps \
    --eval_steps $eval_steps \
    --num_optim_tokens $num_optim_tokens \
    --lr $lr \
    --batch_size $batch_size \
    --pez_mode $pez_mode \
    --one_prompt $one_prompt \
    --output_file $output_file \
    --input_file $input_file 

