#!/bin/bash

export NGPUS=2

sbatch --gpus=$NGPUS --nodes=1 --time=24:00:00 tune_accelerate.sh "microsoft/deberta-v3-small" "gm_labeled" "hh shp oasst" "5e-6" "2" 29500
sbatch --gpus=$NGPUS --nodes=1 --time=24:00:00 tune_accelerate.sh "microsoft/deberta-v3-base" "gm_labeled" "hh shp oasst" "5e-6" "2" 29501
sbatch --gpus=$NGPUS --nodes=1 --time=24:00:00 tune_accelerate.sh "microsoft/deberta-v3-large" "gm_labeled" "hh shp oasst" "5e-6" "2" 29502


###### adversarial training #####
model_size="base" # small,base,large
optim_steps=30
attack="pez" # gbda
num_tokens=2
model="microsoft/deberta-v3-${model_size}"
train_task="gm_labeled"
test_task="hh shp oasst"
out_file="../out/adv_training/deberta_${model_size}_${attack}_pc${pc}_${optim_steps}steps_${num_tokens}tokens.pkl"
epochs=2
batch_size=256
sbatch --nodes=1 --gpus-per-node=8 --cpus-per-gpu=16 --output="slurm_${attack}_training_${model_size}_${optim_steps}steps_${num_tokens}tokens-%j.out" tune_adv_accelerate.sh $attack $optim_steps $model "$train_task" "$test_task" $out_file $num_tokens $epochs $batch_size
