# Enhance the Transferability of Adversarial Attacks through Channel Pruning
## Environment
We run our code in python=3.7.16.
Please run the following command to install the dependency:
```shell
pip install -r requirements.txt
```
## Datasets preparation
First, download the imagenet2012 dataset from their [official website](<https://image-net.org/download.php>).
Then, run the following command to sample the target dataset for adversarial attacks.
```shell
python sample_dataset.py --save_dir ./data --dataset_dir </path/to/imagenet/dataset>
```
## Obtain Model Augmentation
For all types of surrogate models, rexecute the following command for three times. Note that the path to imagenet2012 dataset is only used for validation purpose. (not for training)
### ResNet-50
```shell
python pruning_imagenet_init_optimize.py -a resnet50 --save_dir ./model_resnet50 --layer_begin 0 --layer_end 156 --layer_inter 3 --use_pretrain --epochs 0 -b 64 --init_optimize --init_optimize_algorithm SSKD --init_optimize_lr 0.01 --transform random_mask --reg_weight 10000 --s_epoch 200 --sampled_data ./data </path/to/imagenet/dataset>
```
### ResNet-101
```shell
python pruning_imagenet_init_optimize.py -a resnet101 --save_dir ./model_resnet101 --layer_begin 0 --layer_end 309 --layer_inter 3 --use_pretrain --epochs 0 -b 64 --init_optimize --init_optimize_algorithm SSKD --init_optimize_lr 0.01 --transform random_mask --reg_weight 10000 --s_epoch 200 --sampled_data ./data </path/to/imagenet/dataset>
```

### Inception-v3
```shell
python pruning_imagenet_init_optimize.py -a inception_v3 --save_dir ./model_inceptionv3 --layer_begin 0 --layer_end 279 --layer_inter 3 --use_pretrain --epochs 0 -b 64 --init_optimize --init_optimize_algorithm SSKD --init_optimize_lr 0.01 --transform random_mask --reg_weight 10000 --s_epoch 200 --sampled_data ./data </path/to/imagenet/dataset>
```

### VGG-16
```shell
python pruning_imagenet_init_optimize.py -a vgg16_bn --save_dir ./model_inceptionv3 --layer_begin 0 --layer_end 48 --layer_inter 4 --use_pretrain --epochs 0 -b 64 --init_optimize --init_optimize_algorithm SSKD --init_optimize_lr 0.01 --transform random_mask --reg_weight 10000 --t_epoch 200 --s_epoch 200 --sampled_data ./data </path/to/imagenet/dataset>
```

### DenseNet-121
```shell
python pruning_imagenet_init_optimize.py -a densenet121 --save_dir ./model_inceptionv3 --layer_begin 5 --layer_end 359 --layer_inter 3 --use_pretrain --epochs 0 -b 64 --init_optimize --init_optimize_algorithm SSKD --init_optimize_lr 0.01 --transform random_mask --reg_weight 10000 --s_epoch 200 --sampled_data ./data </path/to/imagenet/dataset>
```

## Attacks
Take ResNet-50 => Inception-v3 as the example.
Targeted attacks:
```shell
python attack_with_random_augmented_pruned_models.py --targeted --arch resnet50 --models_dir ./model_resnet50 --save_dir ./log --target_model inception_v3 --prefix test_inc_v3_ --num_models 3 ./data
```
Untargeted attacks:
```shell
python attack_with_random_augmented_pruned_models.py --arch resnet50 --models_dir ./model_resnet50 --save_dir ./log --target_model inception_v3 --prefix test_inc_v3_ --num_models 3 ./data
```

## References:
1. https://github.com/he-y/filter-pruning-geometric-median
2. https://github.com/Harry24k/adversarial-attacks-pytorch
3. https://github.com/huggingface/pytorch-image-models/tree/main
