import os, sys
import torch

def accuracy(output: torch.Tensor, target: torch.Tensor, topk=(1,)):
    """Computes the precision@k for the specified values of k"""
    maxk = max(topk)
    batch_size = target.size(0)

    _, pred = output.topk(maxk, dim=1, largest=True, sorted=True)
    pred = pred.t() # (maxk, batch_size)
    correct = pred.eq(target.view(1, -1).expand_as(pred))
    # print("size of the correct tensor: ", correct.size())

    res = []
    for k in topk:
        correct_k = correct[:k].reshape((-1,)).float().sum(0, keepdim=True)
        res.append(correct_k.mul_(100.0 / batch_size))
    return res