def hypervolume(front, ref):
    if len(front) < 2 or len(ref) < 1:
        raise ValueError('inputs')

    front_sorted = sorted(front, key=lambda x: x[0])

    hv = 0

    m = len(front_sorted)

    last_height = ref[0]

    for i in range(m):
        width = [ref[j] - front_sorted[i][j] for j in range(len(ref))]
        height = last_height - front_sorted[i][0]
        area = 1
        for w in width:
            area *= w
        area *= height

        hv += area
        last_height = front_sorted[i][0]

    return hv

def inverse_first_dimension(data):

    inverse_data = []
    for item in data:
        inverted_item = [1/item[0],item[1]]
        inverse_data.append(inverted_item)
    print(inverse_data)
    return inverse_data


def normalize_2d(data):
    print(data)
    num_features = len(data[0])
    normalized_data = []

    for i in range(num_features):
        feature_values = [point[i] for point in data]
        max_val = max(feature_values)
        min_val = min(feature_values)
        normalized_feature = [(x - min_val) / (max_val - min_val) for x in feature_values]
        normalized_data.append(normalized_feature)
    normalized_data = list(zip(*normalized_data))

    return normalized_data





