## Quick Start

### Installation

```bash
conda create -n verl python==3.9
conda activate verl
pip3 install torch==2.4.0 --index-url https://download.pytorch.org/whl/cu124
pip3 install flash-attn --no-build-isolation
pip3 install -e . 
```

### Generation & Evaluation

```bash
bash eval_math_nodes.sh \
    --run_name Qwen2.5-7B_minerva_math_temp0.6_n32_seed1 \
    --init_model Qwen2.5-7B \
    --template qwen-boxed  \
    --tp_size 1 \
    --add_step_0 true  \
    --temperature 2.0 \
    --top_p 0.95 \
    --max_tokens 16000 \
    --benchmarks minerva_math \
    --n_sampling 32 \
    --just_wandb false \
    --seed 1
```

After running the script, the evaluation results will be saved in `examples/math_eval/EVAL/checkpoints/$RUN_NAME/eval_results`, with the metrics saved in `$RUN_NAME/eval_results/eval_results.csv`. A useful function to get the *pass@k* data is given in `pass@k.py`. You can modify it and get the *pass@k* data.
