import numpy as np

def get_pass_k_data(file_dir_path, model_name, benchmark_name, template, temperature, total_questions_num, n, seed_max):
    N = n * seed_max
    print('N = ', N)

    def read_jsonl_file(file_dir_path, model_name, True_n_ls, total_questions_num, n, seed_max):
        # YOU NEED TO ADD YOUR CODE
        pass
    
    def pass_at_k(n, c, k):
        if n - c < k: return 1.0
        return 1.0 - np.prod(1.0 - k / np.arange(n - c + 1, n + 1))

    True_n_ls = [[0 for i in range(total_questions_num)] for j in range(N)]
    read_jsonl_file(file_dir_path, model_name, True_n_ls, total_questions_num, n, seed_max)
    True_n_ls = np.array(True_n_ls)

    correct_ls = [0 for i in range(total_questions_num)]
    for i in range(total_questions_num):
        for j in range(n * seed_max):
            correct_ls[i] += True_n_ls[j][i]

    # print("correct_ls = ", correct_ls)
    pass_at_k_ls = [[] for i in range(N)]
    for i in range(N):
        for j in range(total_questions_num):
            pass_at_k_ls[i].append(pass_at_k(n * seed_max, correct_ls[j], i+1))
    
    # print("pass_at_k_ls = ", pass_at_k_ls)

    pass_at_k_mean_ls = [np.mean(pass_at_k_ls[i]) for i in range(N)]
    # print("pass_at_k_mean_ls = ", pass_at_k_mean_ls)

    pass_at_k_mean_ls = np.array(pass_at_k_mean_ls)

    return pass_at_k_mean_ls
