
#%%
import numpy as np
import string
import copy



#%%
def sample_from_simplex(dim, np_rng=None):
    if np_rng is None:
        np_rng = np.random
    x = np_rng.rand(dim)
    x.sort()
    sample = np.diff(np.concatenate(([0], x, [1])))
    
    return sample

#%%
def make_rational(string):
    try:
        float(string)
        return float(string)
    except ValueError:
        nom, denom = string.split('/')
        return int(nom) / int(denom)


# %%
def is_float_or_rational(string):
    try:
        float(string)
        return True
    except ValueError:
        values = string.split('/')
        return len(values) == 2 and all(i.isdigit() for i in values)


def afewletters(k):
    if k <= 26:
        letters = list(string.ascii_lowercase[:k])
    else:
        letters = [string.ascii_lowercase[i % 26] + str( 1 + (i // 26) ) for i in range(k)]
    
    return letters


def change_yaml(standard,changes):
    #Changes the standard yaml file according to the changes dictionary
    new = copy.deepcopy(standard)
    for key, value in changes.items():
        if key == "delete":
            for key_lists in value:
                recursive = new
                for subkey in key_lists[:-1]:
                    recursive = recursive[subkey]
                del recursive[key_lists[-1]]
        elif key not in new:
            raise Exception("Key", key, "not found in standard yaml file")
        elif isinstance(value, dict):
            for subkey, subvalue in value.items():
                new[key][subkey] = subvalue
        else:    
            new[key] = value
    return new

def logging_frequency(time_not_iter=False):
    if time_not_iter:
        return 10
    else:
        return 10