# Decision Making under Imperfect Recall: Algorithms and Benchmarks

## Getting Started

- Download this folder. In general, make sure to be in this folder directory if you want to run any file.
- Create a conda environment with python 3.11.4 and the right packages from environment.yml through the command 'conda env create -f environment.yml', activate it

## Overview
- ./generating_decision_problems.sh generates decision problems of different types of different sizes. Call it via 'bash generating_decision_problems.sh'. Uncomment one of two lines to allow for generation of larger decision problems.
- ./running_experiments.sh runs algorithms on (generated) decision problems and logs their progress. You require a license to run gurobi. Call it via 'bash running_experiments.sh'. Uncomment lines to allow for solving of all previously generated decision problems (small and large), and for allowing many runs.
- ./get_plots_and_data.py runs uses the logs to bring together the results in one csv file saved under ./plots/values_and_times_summary/results1.csv, and to plot the results per instance. Call it via 'python get_plots_and_data.py'. The folder './plots/best_convergence/' only plots the best runs of GD, OGD, and AMS. You can compare individual algorithm parameter configurations instead by uncommenting the last line, and these files are saved in the folder './plots/convergence/'.
- ./decisionproblems/ contains (1) the decision problem benchmarks used in the paper, (2) the specifications files for generating such decision problems (with an implemented.txt file that explains what options we have already implemented), and (3) a few simple instances on which we can test basic functionalities
- ./modules/ contains the methods for processing decision problems, generating them, solving them with the algorithms discussed in the paper, and evaluation the algorithm runs
- ./plots/ contains the plots, and other info needed for visualizing results
- ./runs/ contains the logs of the algorithm runs

## Results are available online
- The benchmark decision problems we generated for this paper are too large to be provided to the supplementary material. Thus, we provide the full folder under the following Google drive link: [https://drive.google.com/file/d/1v4WhJjRiZkOKegTvPeTXgBZtYLN_N1S7/view?usp=sharing](https://drive.google.com/file/d/1v4WhJjRiZkOKegTvPeTXgBZtYLN_N1S7/view?usp=sharing)
    - The benchmark decision problems can be found under './decisionproblems/TYPE' where TYPE is one of {simulation, detection, random}. They are divided in different size categories. You can find how many nodes an instance has from the forth line of its text file. This is needed to match the instances to their naming 'TYPE-NUMNODES' we use in the paper submission
    - The experiments on these decision problems can be found under './runs/'
    - The plots from these experiments can be found under './plots/best_convergence/' and './plots/convergence/'