import glob
from modules.evaluations.plot_convergence_per_game import plot_and_save_best, plot_and_save_games
from modules.evaluations.compare_times import summarize_data

folders_descr = "./runs/*/*/*"
logfolders = glob.glob(folders_descr)

summarize_data(logfolders, save=True)
plot_and_save_best(logfolders, confidencepercentile=0.3, add_value_iter=True, max_length={'iter': 3000}, algo_exclusions=[])

### BELOW PLOTS EACH GD/OGD/AMS PARAMETER SETTING AS AN INDIVIDUAL ALGORITHM ###
# plot_and_save_games(logfolders, confidencepercentile=0.3, which_plots={'value-time': True, 'gap-iter': True, 'value-iter': False, 'gap-time': False}, max_length={'time': 14400, 'iter': 3000}, algo_exclusions=[])
