# Vision Tasks

def get_merging_cofficients(method='task_arithmetic', model='ViT-B-32'):
    task_num = 8
    avg_weight = 1 / task_num
    prior_weight = 0.3

    print('method: '+method)
    print('model: '+model)

    if method == 'weight_averaging':
        # Weight Averaging
        ralpha = [[1.0000, avg_weight, avg_weight, avg_weight, avg_weight, avg_weight, avg_weight, avg_weight]] # pretrained weight + tasks weights

    elif method in ['task_arithmetic', 'ties_merging']:
        # task arithmetic / Ties-Merging
        ralpha = [[1.0000, prior_weight, prior_weight, prior_weight, prior_weight, prior_weight, prior_weight, prior_weight, prior_weight]]

    # 'ViT-B-32'
    elif method == 'tw_adamerging' and model == 'ViT-B-32':
        # Task-wise AdaMerging ViT-B/32
        ralpha = [[1.0000, 0.2202, 0.1413, 0.2826, 0.3284, 0.2841, 0.4003, 0.1978, 0.1692]]

    elif method == 'tw_adamergingpp' and model == 'ViT-B-32':
        # Task-wise AdaMerging++ ViT-B/32
        ralpha = [[1.0000, 0.3171, 0.1698, 0.4235, 0.5198, 0.4386, 0.5803, 0.2452, 0.2885]]

    elif method == 'lw_adamerging' and model == 'ViT-B-32':
        # Layer-wise AdaMerging ViT-B/32
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.0000, 0.0000, 0.0359, 0.0280, 0.0454, 0.0043, 0.0329, 0.0000], [1.0000, 0.0577, 0.0312, 0.0707, 0.1015, 0.0978, 0.0477, 0.0549, 0.0957], [1.0000, 0.5310, 0.4606, 0.4911, 0.6752, 0.1034, 0.5205, 0.3384, 0.7028], [1.0000, 0.0549, 0.0579, 0.1006, 0.0606, 0.1267, 0.1299, 0.0686, 0.1118], [1.0000, 0.0061, 0.0000, 0.0000, 0.0000, 0.0358, 0.0185, 0.0153, 0.0000], [1.0000, 0.3828, 0.4305, 0.2001, 0.3216, 0.3003, 0.2386, 0.1551, 0.3449], [1.0000, 0.2226, 0.2686, 0.3682, 0.3201, 0.1370, 0.1034, 0.1172, 0.4263], [1.0000, 0.3481, 0.3484, 0.3429, 0.3365, 0.3016, 0.3111, 0.2932, 0.3521], [1.0000, 0.2910, 0.4093, 0.2881, 0.1685, 0.1556, 0.0302, 0.1425, 0.3097], [1.0000, 0.2703, 0.3040, 0.2583, 0.2119, 0.2094, 0.1153, 0.0755, 0.2840], [1.0000, 0.3354, 0.4000, 0.2584, 0.1398, 0.2021, 0.0785, 0.0733, 0.3987], [1.0000, 0.1568, 0.3252, 0.0966, 0.2639, 0.1766, 0.0726, 0.0552, 0.2845], [1.0000, 0.3236, 0.3494, 0.2183, 0.2457, 0.2832, 0.2644, 0.4176, 0.3003], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0756, 0.1787, 0.0359, 0.1973, 0.1904, 0.1789, 0.0956, 0.0376], [1.0000, 0.0928, 0.1623, 0.0658, 0.1796, 0.1689, 0.1371, 0.0949, 0.1165], [1.0000, 0.0197, 0.0395, 0.0000, 0.0407, 0.0813, 0.0701, 0.0453, 0.0228], [1.0000, 0.0951, 0.1009, 0.0333, 0.1110, 0.1034, 0.0841, 0.0588, 0.0924], [1.0000, 0.2008, 0.2493, 0.2721, 0.3108, 0.3169, 0.2518, 0.3072, 0.2256], [1.0000, 0.3505, 0.3459, 0.3715, 0.3139, 0.1614, 0.1307, 0.0904, 0.4202], [1.0000, 0.2192, 0.2788, 0.3735, 0.1971, 0.3267, 0.1076, 0.1002, 0.1736], [1.0000, 0.0000, 0.0367, 0.0000, 0.0000, 0.0227, 0.0216, 0.0270, 0.0078], [1.0000, 0.2441, 0.2387, 0.2342, 0.0563, 0.3435, 0.0936, 0.1097, 0.3358], [1.0000, 0.2455, 0.2809, 0.0490, 0.0882, 0.0727, 0.0518, 0.0696, 0.1528], [1.0000, 0.1343, 0.1131, 0.1335, 0.1295, 0.1551, 0.1434, 0.1511, 0.1373], [1.0000, 0.0672, 0.0658, 0.0236, 0.0186, 0.1196, 0.0933, 0.0699, 0.0438], [1.0000, 0.2048, 0.0993, 0.0517, 0.4416, 0.3015, 0.4207, 0.0853, 0.0245], [1.0000, 0.3215, 0.3153, 0.1846, 0.3509, 0.3256, 0.2865, 0.2221, 0.2886], [1.0000, 0.0361, 0.0000, 0.0251, 0.1666, 0.1872, 0.0580, 0.0171, 0.0000], [1.0000e+00, 2.1209e-01, 2.7809e-01, 7.1147e-02, 3.3306e-01, 2.9433e-01, 3.4454e-02, 8.1267e-04, 1.2272e-01], [1.0000, 0.3985, 0.2547, 0.4866, 0.4904, 0.4998, 0.4993, 0.4575, 0.4491], [1.0000, 0.2635, 0.2706, 0.2515, 0.3040, 0.3124, 0.2828, 0.1576, 0.2463], [1.0000, 0.2316, 0.1143, 0.1914, 0.2938, 0.5551, 0.4704, 0.2448, 0.2287], [1.0000, 0.0470, 0.0775, 0.0289, 0.0743, 0.0631, 0.0535, 0.0120, 0.0265], [1.0000, 0.1285, 0.1398, 0.0450, 0.1958, 0.5507, 0.1973, 0.0856, 0.0197], [1.0000, 0.0907, 0.0697, 0.0369, 0.0743, 0.0195, 0.0096, 0.0000, 0.0453], [1.0000, 0.0616, 0.0631, 0.0649, 0.0656, 0.0659, 0.0661, 0.0658, 0.0686], [1.0000, 0.0000, 0.0000, 0.0000, 0.0027, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.0478, 0.0000, 0.0151, 0.0517, 0.1659, 0.1965, 0.0593, 0.0626], [1.0000, 0.5194, 0.4921, 0.4720, 0.4091, 0.4370, 0.4206, 0.4314, 0.5017], [1.0000, 0.0000, 0.0000, 0.0133, 0.0433, 0.0368, 0.0547, 0.0270, 0.0000], [1.0000, 0.0038, 0.0219, 0.0210, 0.0473, 0.0204, 0.0250, 0.0248, 0.0135], [1.0000, 0.0474, 0.0335, 0.1014, 0.0323, 0.0000, 0.0000, 0.0000, 0.0778], [1.0000, 0.4819, 0.5025, 0.4605, 0.4462, 0.3139, 0.2160, 0.3647, 0.5353], [1.0000, 0.1745, 0.1100, 0.3673, 0.2670, 0.3711, 0.3170, 0.1918, 0.1498], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2789, 0.1958, 0.1021, 0.2970, 0.4876, 0.4551, 0.2535, 0.1506], [1.0000, 0.0228, 0.0470, 0.0212, 0.0487, 0.0000, 0.0049, 0.0020, 0.0447], [1.0000, 0.0168, 0.0162, 0.0136, 0.0182, 0.0229, 0.0276, 0.0219, 0.0183], [1.0000, 0.0662, 0.3113, 0.2166, 0.1744, 0.1878, 0.0693, 0.1502, 0.2421], [1.0000, 0.0384, 0.0433, 0.0467, 0.1232, 0.2216, 0.2486, 0.1610, 0.0628], [1.0000, 0.4160, 0.5329, 0.4700, 0.3420, 0.3966, 0.2364, 0.3779, 0.4830], [1.0000, 0.0334, 0.1750, 0.0802, 0.0823, 0.2392, 0.1992, 0.0983, 0.0730], [1.0000e+00, 2.8067e-02, 3.0574e-01, 8.6378e-02, 4.0841e-02, 2.0861e-01, 5.5466e-04, 5.3186e-02, 1.8939e-01], [1.0000, 0.6209, 0.6177, 0.6145, 0.6160, 0.6308, 0.6270, 0.6269, 0.6153], [1.0000e+00, 1.7972e-01, 1.4817e-01, 7.7646e-02, 8.6138e-02, 2.7787e-02, 9.4260e-04, 0.0000e+00, 1.9216e-01], [1.0000, 0.4276, 0.2374, 0.0796, 0.3032, 0.3743, 0.5470, 0.3489, 0.2964], [1.0000, 0.3898, 0.2361, 0.2950, 0.2838, 0.1338, 0.1945, 0.0466, 0.4552], [1.0000, 0.0914, 0.2632, 0.1016, 0.3430, 0.3626, 0.6230, 0.3124, 0.1836], [1.0000, 0.0346, 0.0481, 0.0352, 0.0184, 0.0000, 0.0000, 0.0000, 0.0442], [1.0000, 0.0521, 0.0467, 0.0566, 0.0524, 0.0561, 0.0571, 0.0470, 0.0575], [1.0000, 0.5851, 0.5551, 0.5576, 0.5119, 0.5248, 0.5160, 0.5163, 0.5500], [1.0000, 0.0662, 0.2505, 0.1866, 0.1261, 0.2724, 0.6081, 0.2433, 0.1895], [1.0000, 0.5567, 0.5304, 0.5625, 0.4224, 0.3149, 0.3952, 0.3964, 0.5348], [1.0000, 0.0000, 0.1847, 0.0596, 0.0016, 0.0147, 0.2531, 0.1169, 0.0428], [1.0000, 0.4275, 0.5366, 0.4649, 0.2381, 0.0212, 0.1552, 0.3146, 0.3967], [1.0000, 0.3132, 0.3361, 0.3379, 0.3163, 0.2973, 0.3023, 0.2738, 0.3501], [1.0000, 0.6066, 0.6135, 0.6042, 0.5958, 0.5360, 0.5490, 0.5705, 0.6011], [1.0000, 0.1458, 0.4718, 0.2439, 0.2821, 0.3299, 0.5909, 0.0560, 0.2367], [1.0000, 0.0348, 0.0834, 0.1506, 0.0066, 0.0000, 0.0000, 0.0000, 0.0383], [1.0000, 0.2511, 0.2405, 0.3157, 0.4645, 0.5621, 0.6170, 0.4259, 0.1866], [1.0000, 0.0404, 0.0682, 0.0598, 0.0064, 0.0000, 0.0000, 0.0123, 0.0283], [1.0000, 0.0903, 0.1013, 0.1185, 0.0971, 0.1004, 0.0981, 0.1216, 0.0981], [1.0000, 0.6200, 0.6140, 0.5970, 0.5956, 0.5906, 0.5831, 0.5978, 0.6050], [1.0000, 0.1932, 0.2155, 0.3723, 0.3923, 0.4033, 0.6304, 0.4227, 0.1447], [1.0000, 0.6100, 0.5644, 0.5691, 0.4607, 0.3450, 0.4210, 0.3297, 0.5604], [1.0000, 0.0589, 0.0466, 0.2890, 0.1862, 0.0920, 0.2088, 0.0160, 0.0612], [1.0000, 0.4718, 0.4847, 0.4406, 0.3021, 0.2365, 0.0712, 0.0762, 0.4064], [1.0000, 0.3922, 0.3708, 0.4140, 0.3885, 0.3581, 0.3553, 0.3451, 0.4235], [1.0000, 0.5758, 0.5632, 0.5647, 0.5425, 0.5858, 0.5669, 0.5586, 0.5725], [1.0000, 0.1647, 0.2310, 0.3740, 0.4512, 0.5175, 0.5275, 0.3085, 0.3623], [1.0000, 0.0360, 0.0496, 0.2324, 0.0641, 0.0352, 0.0000, 0.0000, 0.0021], [1.0000, 0.0676, 0.0857, 0.4286, 0.4161, 0.6094, 0.6547, 0.5730, 0.4052], [1.0000, 0.0032, 0.0045, 0.0267, 0.0000, 0.0559, 0.0000, 0.0140, 0.0482], [1.0000, 0.0343, 0.0506, 0.0557, 0.0622, 0.0947, 0.0517, 0.0625, 0.0570], [1.0000, 0.6142, 0.6165, 0.6019, 0.6041, 0.6084, 0.6048, 0.6068, 0.6161], [1.0000, 0.1441, 0.3090, 0.3299, 0.4927, 0.4007, 0.6999, 0.5755, 0.5129], [1.0000, 0.5406, 0.5373, 0.4651, 0.4999, 0.4580, 0.5077, 0.4321, 0.5964], [1.0000, 0.0701, 0.0771, 0.1898, 0.2482, 0.0228, 0.2484, 0.0782, 0.3179], [1.0000, 0.1203, 0.0778, 0.1347, 0.1073, 0.0000, 0.0000, 0.0000, 0.2142], [1.0000, 0.0455, 0.0396, 0.0407, 0.0413, 0.0451, 0.0381, 0.0396, 0.0449], [1.0000, 0.4425, 0.4218, 0.4311, 0.4205, 0.4114, 0.3924, 0.4021, 0.4505], [1.0000, 0.5429, 0.4294, 0.3045, 0.4960, 0.3979, 0.6963, 0.4773, 0.5504], [1.0000, 0.1620, 0.0658, 0.1222, 0.1144, 0.0438, 0.0230, 0.0502, 0.0512], [1.0000, 0.3562, 0.3388, 0.3517, 0.4641, 0.3743, 0.6429, 0.4966, 0.3539], [1.0000, 0.1643, 0.0560, 0.0700, 0.2064, 0.1093, 0.0433, 0.0562, 0.0650], [1.0000, 0.4635, 0.4779, 0.4984, 0.5041, 0.4959, 0.4953, 0.5010, 0.4958], [1.0000, 0.3997, 0.3588, 0.3618, 0.3618, 0.3767, 0.3341, 0.3851, 0.3768], [1.0000, 0.3096, 0.2934, 0.5727, 0.5283, 0.4172, 0.7115, 0.5191, 0.3686], [1.0000, 0.2339, 0.0776, 0.3103, 0.2629, 0.0269, 0.0052, 0.1070, 0.0228], [1.0000, 0.0904, 0.0934, 0.2374, 0.2387, 0.3802, 0.3140, 0.1248, 0.0513], [1.0000, 0.0191, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.2293, 0.2090, 0.2088, 0.2118, 0.2356, 0.2092, 0.2074, 0.2119], [1.0000, 0.3406, 0.3429, 0.3752, 0.3962, 0.3509, 0.3547, 0.3792, 0.2866], [1.0000, 0.3803, 0.5037, 0.5251, 0.5393, 0.3782, 0.7360, 0.5284, 0.6546], [1.0000, 0.0786, 0.2275, 0.2051, 0.2500, 0.1184, 0.1776, 0.1965, 0.0514], [1.0000, 0.1616, 0.5576, 0.5694, 0.4522, 0.5085, 0.7213, 0.6048, 0.4796], [1.0000, 0.0513, 0.0170, 0.0280, 0.1411, 0.1186, 0.0000, 0.1803, 0.0136], [1.0000, 0.2245, 0.2360, 0.2409, 0.2422, 0.2658, 0.2426, 0.2265, 0.2219], [1.0000, 0.3558, 0.3575, 0.3523, 0.3862, 0.3777, 0.3598, 0.3678, 0.3531], [1.0000, 0.2681, 0.5874, 0.5231, 0.5386, 0.4671, 0.7119, 0.5160, 0.5071], [1.0000, 0.1209, 0.1257, 0.0522, 0.2950, 0.1480, 0.1100, 0.0768, 0.0506], [1.0000, 0.0101, 0.0277, 0.0456, 0.1332, 0.0000, 0.1035, 0.0000, 0.0580], [1.0000e+00, 2.7500e-03, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 7.3858e-05], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.6172, 0.6103, 0.6061, 0.5969, 0.5896, 0.5865, 0.5844, 0.6043], [1.0000, 0.5174, 0.6229, 0.6118, 0.5888, 0.5167, 0.7168, 0.5562, 0.4589], [1.0000, 0.1344, 0.1680, 0.1350, 0.1244, 0.0233, 0.0234, 0.0277, 0.0559], [1.0000, 0.4012, 0.6131, 0.6568, 0.5680, 0.4350, 0.7170, 0.4672, 0.5043], [1.0000, 0.0949, 0.0515, 0.0504, 0.0832, 0.0000, 0.0000, 0.0179, 0.0474], [1.0000e+00, 1.4383e-03, 2.9790e-04, 2.2795e-03, 4.9502e-03, 1.1892e-03, 1.5378e-03, 3.1967e-03, 2.9153e-03], [1.0000, 0.5893, 0.5791, 0.5821, 0.5752, 0.5808, 0.5597, 0.5790, 0.5748], [1.0000, 0.4934, 0.4810, 0.5807, 0.4941, 0.5118, 0.7127, 0.3591, 0.5981], [1.0000, 0.3947, 0.1339, 0.2287, 0.2904, 0.3082, 0.0638, 0.1230, 0.1410], [1.0000, 0.0786, 0.0638, 0.0847, 0.4720, 0.0277, 0.1671, 0.0000, 0.1037], [1.0000, 0.0503, 0.0353, 0.0258, 0.0195, 0.0000, 0.0000, 0.0000, 0.0119], [1.0000, 0.1381, 0.1186, 0.1104, 0.0931, 0.0931, 0.1081, 0.0959, 0.1018], [1.0000, 0.5112, 0.5299, 0.5165, 0.5274, 0.5090, 0.5288, 0.5168, 0.4889], [1.0000, 0.3646, 0.6510, 0.6141, 0.5834, 0.0879, 0.7433, 0.3526, 0.5435], [1.0000, 0.4098, 0.5664, 0.4023, 0.5939, 0.5579, 0.5535, 0.4663, 0.3390], [1.0000, 0.6484, 0.6723, 0.6661, 0.5812, 0.3168, 0.7390, 0.5614, 0.7355], [1.0000, 0.0256, 0.0159, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.0133, 0.0200, 0.0180, 0.0184, 0.0227, 0.0201, 0.0191, 0.0207], [1.0000, 0.1271, 0.1391, 0.1421, 0.1516, 0.1559, 0.1316, 0.1494, 0.1235], [1.0000, 0.4462, 0.5960, 0.6764, 0.5877, 0.3665, 0.7224, 0.6449, 0.6976], [1.0000, 0.0027, 0.0193, 0.0428, 0.0146, 0.0000, 0.0067, 0.0251, 0.0309], [1.0000, 0.2994, 0.0026, 0.1992, 0.3578, 0.2945, 0.4063, 0.0000, 0.0657], [1.0000, 0.0149, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.6445, 0.7190, 0.6427, 0.5774, 0.5743, 0.7029, 0.4080, 0.6221], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.7038, 0.6824, 0.7004, 0.6607, 0.5234, 0.7207, 0.7249, 0.7818], [1.0000, 0.1733, 0.0201, 0.0424, 0.1828, 0.0000, 0.0000, 0.0000, 0.0725], [1.0000, 0.7411, 0.7313, 0.7346, 0.7357, 0.7217, 0.7337, 0.7256, 0.7366], [1.0000, 0.6483, 0.3719, 0.5482, 0.5661, 0.1616, 0.2979, 0.1347, 0.5736], [1.0000, 0.6270, 0.5696, 0.2433, 0.6323, 0.0685, 0.4459, 0.0843, 0.3871], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1005, 0.0840, 0.0560, 0.0833, 0.0000, 0.0019, 0.0000, 0.0859], [1.0000, 0.1293, 0.2083, 0.1141, 0.3172, 0.0799, 0.0773, 0.0370, 0.1290], [1.0000, 0.7034, 0.6641, 0.6774, 0.6646, 0.6658, 0.6833, 0.6915, 0.6878], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    elif method == 'lw_adamergingpp' and model == 'ViT-B-32':
        # Layer-wise AdaMerging++ ViT-B/32
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.0000, 0.0000, 0.0727, 0.0798, 0.1120, 0.0458, 0.0793, 0.0000], [1.0000, 0.1355, 0.1479, 0.1251, 0.1578, 0.1656, 0.1272, 0.1204, 0.2231], [1.0000, 0.5438, 0.4958, 0.5763, 0.6866, 0.0646, 0.5185, 0.2697, 0.6394], [1.0000, 0.0451, 0.0656, 0.3715, 0.0956, 0.0000, 0.1116, 0.1057, 0.0033], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1653, 0.1644, 0.1250, 0.2056, 0.3120, 0.3696, 0.3963, 0.1157], [1.0000, 0.2231, 0.2655, 0.4654, 0.3938, 0.0968, 0.0759, 0.1487, 0.4833], [1.0000, 0.3589, 0.3578, 0.3581, 0.3602, 0.3265, 0.3377, 0.3384, 0.3692], [1.0000, 0.1326, 0.1715, 0.1924, 0.1969, 0.0561, 0.0972, 0.2721, 0.2055], [1.0000, 0.1081, 0.1144, 0.1250, 0.1819, 0.0834, 0.1304, 0.1353, 0.1359], [1.0000, 0.2541, 0.2763, 0.1621, 0.2442, 0.2361, 0.3051, 0.3184, 0.2397], [1.0000, 0.0767, 0.2793, 0.1404, 0.1968, 0.2727, 0.3327, 0.4153, 0.1497], [1.0000, 0.3487, 0.3889, 0.2967, 0.3419, 0.3887, 0.3819, 0.4913, 0.3601], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0030, 0.0000, 0.0000, 0.0000], [1.0000, 0.0916, 0.1904, 0.0986, 0.3465, 0.2899, 0.2482, 0.1534, 0.0054], [1.0000, 0.0586, 0.1262, 0.0341, 0.1403, 0.1625, 0.1396, 0.1019, 0.0634], [1.0000, 0.0167, 0.0253, 0.0000, 0.1105, 0.1549, 0.0918, 0.0382, 0.0138], [1.0000, 0.0363, 0.0279, 0.0057, 0.2600, 0.0790, 0.0579, 0.0305, 0.0806], [1.0000, 0.2731, 0.2508, 0.2933, 0.3003, 0.2836, 0.2527, 0.2682, 0.2565], [1.0000, 0.4732, 0.5214, 0.4843, 0.4802, 0.4718, 0.3576, 0.3521, 0.4938], [1.0000, 0.3083, 0.2244, 0.3715, 0.2712, 0.3398, 0.1475, 0.1475, 0.1430], [1.0000, 0.0354, 0.0385, 0.0253, 0.0000, 0.0223, 0.0216, 0.0331, 0.0427], [1.0000, 0.3500, 0.1851, 0.2725, 0.1428, 0.5497, 0.3021, 0.2392, 0.1943], [1.0000, 0.2380, 0.2972, 0.0345, 0.0990, 0.1016, 0.1686, 0.1644, 0.0085], [1.0000, 0.3012, 0.2099, 0.2742, 0.3177, 0.3060, 0.3191, 0.3075, 0.2911], [1.0000e+00, 0.0000e+00, 2.0617e-04, 0.0000e+00, 0.0000e+00, 1.8289e-01, 2.6684e-01, 1.2302e-01, 0.0000e+00], [1.0000, 0.1933, 0.0642, 0.0232, 0.5096, 0.4907, 0.5723, 0.2154, 0.0000], [1.0000, 0.2812, 0.3751, 0.2904, 0.5682, 0.5624, 0.4982, 0.5563, 0.2398], [1.0000, 0.0571, 0.0000, 0.0068, 0.2574, 0.4581, 0.2279, 0.0321, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.4481, 0.5860, 0.5674, 0.5791, 0.0000], [1.0000, 0.3435, 0.1907, 0.4736, 0.4803, 0.4831, 0.4895, 0.4198, 0.4203], [1.0000, 0.3523, 0.3556, 0.4288, 0.4674, 0.5585, 0.4594, 0.3395, 0.3444], [1.0000, 0.1898, 0.0889, 0.1550, 0.3757, 0.5635, 0.5863, 0.2850, 0.2109], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0090, 0.0000, 0.0000, 0.0000], [1.0000, 0.0733, 0.0303, 0.0264, 0.3048, 0.5902, 0.4508, 0.1295, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0096, 0.0000, 0.0126, 0.0115, 0.0134, 0.0121, 0.0131], [1.0000, 0.0000, 0.0000, 0.0000, 0.0364, 0.0390, 0.0065, 0.0098, 0.0000], [1.0000, 0.0885, 0.0090, 0.0099, 0.0378, 0.4190, 0.3835, 0.1482, 0.0504], [1.0000, 0.4598, 0.3870, 0.0547, 0.0363, 0.4214, 0.3141, 0.3646, 0.2881], [1.0000, 0.0000, 0.0000, 0.0000, 0.0418, 0.0413, 0.0667, 0.0606, 0.0000], [1.0000, 0.6233, 0.4582, 0.1683, 0.3469, 0.4268, 0.1497, 0.5378, 0.1928], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.5956, 0.5792, 0.5820, 0.4539, 0.6063, 0.3773, 0.5892, 0.5692], [1.0000, 0.3513, 0.1026, 0.3590, 0.2342, 0.4379, 0.4265, 0.2639, 0.2767], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3331, 0.1443, 0.0921, 0.4420, 0.5288, 0.6600, 0.4574, 0.2736], [1.0000, 0.0667, 0.0196, 0.0000, 0.0427, 0.0510, 0.0000, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0024, 0.0000, 0.0000], [1.0000, 0.2008, 0.2650, 0.2493, 0.2872, 0.4063, 0.2002, 0.1945, 0.3307], [1.0000, 0.1315, 0.0248, 0.1114, 0.1876, 0.3056, 0.4058, 0.1912, 0.0419], [1.0000, 0.4073, 0.5987, 0.5499, 0.3484, 0.4841, 0.3318, 0.4798, 0.4976], [1.0000, 0.0000, 0.1277, 0.0156, 0.3053, 0.2940, 0.5277, 0.2266, 0.0000], [1.0000, 0.5764, 0.5944, 0.3575, 0.5624, 0.4706, 0.6025, 0.5507, 0.0000], [1.0000, 0.6392, 0.6350, 0.6348, 0.6364, 0.6482, 0.6438, 0.6360, 0.6387], [1.0000, 0.0314, 0.0671, 0.0267, 0.0438, 0.0246, 0.0604, 0.0049, 0.0580], [1.0000, 0.4311, 0.2845, 0.0680, 0.3190, 0.3824, 0.6249, 0.3543, 0.2552], [1.0000, 0.2917, 0.2291, 0.2483, 0.2362, 0.2607, 0.3086, 0.2122, 0.2887], [1.0000, 0.1437, 0.3227, 0.1428, 0.4234, 0.3977, 0.6673, 0.3272, 0.2751], [1.0000, 0.0000, 0.0282, 0.0000, 0.0565, 0.0157, 0.0000, 0.0000, 0.0000], [1.0000, 0.1381, 0.1400, 0.1556, 0.1459, 0.1525, 0.1584, 0.1363, 0.1617], [1.0000, 0.3391, 0.4592, 0.5177, 0.4720, 0.4328, 0.5629, 0.5096, 0.3472], [1.0000, 0.0919, 0.4955, 0.4059, 0.3274, 0.3287, 0.6510, 0.2675, 0.2581], [1.0000, 0.3972, 0.4003, 0.5260, 0.3865, 0.2049, 0.4721, 0.2645, 0.3061], [1.0000, 0.0000, 0.2066, 0.2734, 0.3125, 0.1765, 0.6009, 0.2126, 0.0000], [1.0000, 0.6097, 0.6097, 0.1495, 0.5301, 0.3573, 0.4029, 0.3499, 0.0000], [1.0000, 0.4978, 0.5037, 0.4979, 0.4937, 0.5067, 0.5052, 0.4747, 0.4873], [1.0000, 0.3509, 0.4265, 0.4103, 0.4274, 0.4492, 0.4562, 0.3936, 0.3802], [1.0000, 0.1180, 0.3920, 0.2616, 0.3235, 0.3583, 0.6681, 0.0460, 0.1452], [1.0000, 0.1318, 0.1820, 0.1397, 0.1255, 0.1542, 0.1427, 0.1709, 0.1526], [1.0000, 0.3407, 0.3278, 0.3872, 0.5681, 0.5505, 0.6604, 0.4239, 0.3770], [1.0000e+00, 4.7159e-03, 1.3898e-02, 9.2711e-04, 6.5564e-02, 7.0323e-03, 1.4293e-02, 1.0545e-01, 6.3959e-03], [1.0000, 0.2692, 0.2848, 0.3250, 0.3020, 0.3110, 0.2949, 0.3462, 0.2925], [1.0000, 0.6521, 0.6452, 0.6587, 0.6364, 0.6057, 0.6188, 0.6086, 0.6124], [1.0000, 0.4155, 0.4451, 0.5131, 0.5574, 0.4160, 0.6814, 0.3927, 0.3654], [1.0000, 0.4687, 0.3770, 0.5868, 0.5877, 0.3262, 0.5521, 0.3182, 0.4789], [1.0000, 0.0977, 0.3895, 0.5319, 0.5113, 0.3131, 0.6095, 0.1700, 0.2582], [1.0000, 0.6836, 0.6877, 0.6734, 0.6290, 0.6033, 0.5417, 0.5766, 0.6411], [1.0000, 0.4071, 0.3952, 0.4266, 0.4011, 0.3922, 0.3889, 0.3888, 0.4254], [1.0000, 0.6119, 0.6169, 0.6332, 0.6154, 0.6131, 0.6090, 0.5896, 0.5910], [1.0000, 0.2668, 0.4821, 0.4272, 0.5434, 0.4911, 0.6777, 0.3088, 0.5039], [1.0000, 0.0770, 0.0614, 0.0979, 0.0490, 0.0386, 0.0294, 0.0312, 0.0657], [1.0000, 0.2150, 0.3615, 0.5446, 0.5606, 0.5363, 0.6920, 0.5166, 0.5680], [1.0000, 0.3643, 0.2860, 0.2807, 0.3453, 0.1718, 0.2458, 0.2379, 0.1981], [1.0000, 0.1758, 0.1936, 0.1826, 0.2036, 0.2435, 0.1979, 0.2063, 0.2021], [1.0000, 0.6105, 0.6063, 0.6416, 0.6357, 0.6259, 0.5994, 0.6122, 0.6113], [1.0000, 0.5280, 0.5721, 0.5309, 0.5615, 0.4790, 0.7202, 0.5019, 0.6326], [1.0000, 0.5596, 0.5166, 0.5123, 0.5764, 0.5388, 0.6144, 0.4694, 0.5658], [1.0000, 0.2109, 0.5313, 0.5413, 0.5357, 0.3270, 0.6590, 0.3933, 0.5291], [1.0000, 0.2881, 0.1723, 0.1950, 0.0941, 0.1523, 0.2288, 0.0643, 0.0767], [1.0000, 0.0118, 0.0150, 0.0141, 0.0158, 0.0154, 0.0065, 0.0073, 0.0165], [1.0000, 0.2683, 0.3489, 0.3787, 0.4260, 0.3442, 0.3659, 0.2724, 0.3306], [1.0000, 0.5852, 0.5921, 0.5489, 0.5630, 0.4769, 0.7140, 0.4476, 0.5932], [1.0000, 0.0541, 0.0574, 0.0531, 0.0257, 0.0611, 0.0613, 0.0447, 0.0208], [1.0000, 0.4939, 0.5621, 0.5802, 0.5895, 0.4803, 0.6997, 0.4480, 0.5660], [1.0000, 0.6166, 0.6065, 0.5410, 0.5873, 0.5520, 0.5909, 0.4497, 0.3834], [1.0000, 0.4562, 0.4714, 0.5048, 0.5129, 0.4887, 0.4922, 0.4992, 0.5004], [1.0000, 0.2456, 0.1973, 0.2651, 0.2663, 0.2208, 0.1951, 0.2333, 0.2050], [1.0000, 0.5182, 0.5920, 0.6238, 0.5848, 0.4778, 0.7111, 0.4951, 0.5963], [1.0000, 0.1426, 0.1480, 0.4528, 0.4043, 0.1219, 0.2784, 0.1827, 0.1813], [1.0000, 0.2594, 0.3179, 0.5778, 0.5763, 0.4633, 0.6599, 0.4246, 0.2956], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2941, 0.2770, 0.2713, 0.2655, 0.2955, 0.2940, 0.2688, 0.2666], [1.0000, 0.2326, 0.2353, 0.2624, 0.2775, 0.2152, 0.2581, 0.2250, 0.2215], [1.0000, 0.5821, 0.6686, 0.6296, 0.6066, 0.5074, 0.7219, 0.5285, 0.6423], [1.0000, 0.3194, 0.3566, 0.3592, 0.3632, 0.2958, 0.3360, 0.3138, 0.3452], [1.0000, 0.4535, 0.6528, 0.6322, 0.5863, 0.5228, 0.7180, 0.5437, 0.6166], [1.0000, 0.5531, 0.5977, 0.6373, 0.6825, 0.4683, 0.2463, 0.6205, 0.0937], [1.0000, 0.2701, 0.2913, 0.3159, 0.3123, 0.3295, 0.2960, 0.2689, 0.2810], [1.0000, 0.3485, 0.3550, 0.3676, 0.3841, 0.3742, 0.3795, 0.3670, 0.3602], [1.0000, 0.5128, 0.6500, 0.6124, 0.6154, 0.5110, 0.7160, 0.5039, 0.6253], [1.0000, 0.1933, 0.2678, 0.2481, 0.4565, 0.3171, 0.3681, 0.2436, 0.2012], [1.0000, 0.0000, 0.0158, 0.3451, 0.5064, 0.2207, 0.5040, 0.1818, 0.1478], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1596, 0.1610, 0.1608, 0.1604, 0.1568, 0.1628, 0.1619, 0.1593], [1.0000, 0.4087, 0.4487, 0.4511, 0.4130, 0.3856, 0.4064, 0.4002, 0.4110], [1.0000, 0.6326, 0.6733, 0.6805, 0.6514, 0.5941, 0.7059, 0.5913, 0.6529], [1.0000, 0.1433, 0.1512, 0.1614, 0.1344, 0.0964, 0.1282, 0.0948, 0.1231], [1.0000, 0.5821, 0.6546, 0.6732, 0.6364, 0.5425, 0.7011, 0.5503, 0.6231], [1.0000, 0.0000, 0.0000, 0.1063, 0.6747, 0.0000, 0.0000, 0.2203, 0.0000], [1.0000, 0.0641, 0.0487, 0.0631, 0.0641, 0.0509, 0.0522, 0.0628, 0.0659], [1.0000, 0.4526, 0.4316, 0.4384, 0.4246, 0.4288, 0.4125, 0.4343, 0.4294], [1.0000, 0.6411, 0.6333, 0.6195, 0.6055, 0.5434, 0.7135, 0.4681, 0.6503], [1.0000, 0.3854, 0.0443, 0.1714, 0.3747, 0.3212, 0.1879, 0.1422, 0.1899], [1.0000, 0.1028, 0.0012, 0.2581, 0.5827, 0.3299, 0.5073, 0.0000, 0.2216], [1.0000, 0.0000, 0.0000, 0.0000, 0.0481, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.1154, 0.0915, 0.0907, 0.0780, 0.0751, 0.0871, 0.0731, 0.0877], [1.0000, 0.4901, 0.5187, 0.5088, 0.5458, 0.5154, 0.5345, 0.5265, 0.5267], [1.0000, 0.6102, 0.6779, 0.6584, 0.6655, 0.4384, 0.7178, 0.5621, 0.6489], [1.0000, 0.4296, 0.4452, 0.3904, 0.5035, 0.4331, 0.4549, 0.4237, 0.3680], [1.0000, 0.6520, 0.6659, 0.6677, 0.6599, 0.5139, 0.7024, 0.5744, 0.6804], [1.0000, 0.0000, 0.0000, 0.0000, 0.1313, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.0637, 0.0611, 0.0646, 0.0597, 0.0830, 0.0680, 0.0610, 0.0701], [1.0000, 0.1485, 0.1493, 0.1730, 0.1674, 0.1706, 0.1586, 0.1662, 0.1717], [1.0000, 0.5829, 0.6623, 0.6655, 0.6456, 0.4357, 0.7047, 0.5770, 0.6492], [1.0000, 0.0000, 0.0000, 0.0069, 0.0432, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.4051, 0.0000, 0.4133, 0.5258, 0.4088, 0.5335, 0.0000, 0.1825], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0658, 0.0000, 0.0078, 0.0646, 0.0325, 0.0000, 0.0000], [1.0000, 0.6072, 0.6431, 0.6122, 0.6131, 0.5842, 0.6737, 0.5166, 0.5991], [1.0000, 0.2233, 0.3111, 0.2503, 0.4123, 0.1179, 0.2213, 0.0000, 0.2372], [1.0000, 0.6661, 0.6982, 0.6779, 0.6903, 0.3685, 0.7037, 0.6017, 0.6954], [1.0000, 0.4355, 0.0000, 0.1481, 0.6557, 0.0000, 0.0339, 0.0000, 0.2166], [1.0000, 0.6829, 0.6643, 0.6667, 0.6706, 0.6577, 0.6667, 0.6600, 0.6679], [1.0000, 0.7140, 0.2789, 0.4622, 0.5452, 0.1285, 0.2200, 0.0773, 0.4673], [1.0000, 0.5819, 0.5856, 0.4204, 0.6121, 0.0000, 0.4851, 0.0000, 0.4790], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1452, 0.1404, 0.1140, 0.6195, 0.0000, 0.0000, 0.0000, 0.1183], [1.0000, 0.2775, 0.1580, 0.0528, 0.6656, 0.0051, 0.0927, 0.0000, 0.2040], [1.0000, 0.7810, 0.7725, 0.7624, 0.7640, 0.7527, 0.7509, 0.7536, 0.7665], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    # 'ViT-B-16'
    elif method == 'tw_adamerging' and model == 'ViT-B-16':
        # Task-wise AdaMerging ViT-B/16
        ralpha = [[1.0000, 0.1916, 0.1585, 0.2502, 0.3093, 0.2544, 0.3543, 0.2172, 0.1538]]

    elif method == 'tw_adamergingpp' and model == 'ViT-B-16':
        # Task-wise AdaMerging++ ViT-B/16
        ralpha = [[1.0000, 0.3389, 0.1811, 0.3403, 0.5866, 0.3777, 0.7396, 0.2436, 0.0000]]

    elif method == 'lw_adamerging' and model == 'ViT-B-16':
        # Layer-wise AdaMerging ViT-B/16
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.0000, 0.0000, 0.6714, 0.7091, 0.8630, 0.0000, 0.5934, 0.1048], [1.0000, 0.1028, 0.2651, 0.5764, 0.4980, 0.1430, 0.2740, 0.4377, 0.1051], [1.0000, 0.4438, 0.4085, 0.6657, 0.8573, 0.0565, 0.3448, 0.3543, 0.7103], [1.0000, 0.1004, 0.0564, 0.0000, 0.0000, 0.0000, 0.2657, 0.0000, 0.1574], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1742, 0.0849, 0.0000, 0.0427, 0.4064, 0.4859, 0.1797, 0.0000], [1.0000, 0.4594, 0.4173, 0.4521, 0.4092, 0.3588, 0.3703, 0.6274, 0.4993], [1.0000, 0.1833, 0.1320, 0.2116, 0.2422, 0.2889, 0.3616, 0.3265, 0.2508], [1.0000, 0.2383, 0.1474, 0.2099, 0.0619, 0.0031, 0.2390, 0.5099, 0.0837], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0418, 0.1647, 0.0285, 0.0000], [1.0000, 0.1479, 0.2283, 0.0000, 0.0221, 0.2611, 0.3695, 0.0861, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1994, 0.0000], [1.0000, 0.0863, 0.1513, 0.0505, 0.0000, 0.1402, 0.1986, 0.2885, 0.0400], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2069, 0.0295, 0.2786, 0.3436, 0.4068, 0.4378, 0.2386, 0.1989], [1.0000, 0.3971, 0.2165, 0.4448, 0.5210, 0.4518, 0.3356, 0.2426, 0.4333], [1.0000, 0.0795, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.3421, 0.1085, 0.0000, 0.0472, 0.2513, 0.0000, 0.0000, 0.0319], [1.0000, 0.2845, 0.2812, 0.3251, 0.3402, 0.4177, 0.3459, 0.3333, 0.3800], [1.0000, 0.2354, 0.2284, 0.2197, 0.1959, 0.4093, 0.2460, 0.2633, 0.1927], [1.0000, 0.1723, 0.1106, 0.1896, 0.1435, 0.5072, 0.2265, 0.2740, 0.3194], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1554, 0.3144, 0.0000, 0.2055, 0.6295, 0.1956, 0.0877, 0.1370], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0938, 0.0000, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0469, 0.0574, 0.0000, 0.2173, 0.3402, 0.1816, 0.0959, 0.0046], [1.0000, 0.0166, 0.1555, 0.0000, 0.3685, 0.2521, 0.4575, 0.0000, 0.0000], [1.0000, 0.7038, 0.6391, 0.6197, 0.6193, 0.5513, 0.5340, 0.5030, 0.6607], [1.0000, 0.0000, 0.0000, 0.0000, 0.0310, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.1392, 0.1247, 0.0000, 0.2106, 0.0716, 0.0000, 0.0000, 0.0000], [1.0000, 0.5163, 0.4357, 0.5166, 0.5154, 0.5671, 0.5607, 0.5110, 0.5276], [1.0000, 0.0911, 0.1502, 0.0622, 0.0579, 0.0185, 0.0000, 0.0000, 0.0602], [1.0000, 0.1870, 0.2332, 0.0625, 0.2448, 0.6292, 0.5939, 0.1386, 0.1637], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2064, 0.2130, 0.0425, 0.3614, 0.5209, 0.5248, 0.0000, 0.0364], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0579, 0.2458, 0.3069, 0.0211, 0.3154, 0.2725, 0.1178, 0.1770], [1.0000, 0.2008, 0.2138, 0.0844, 0.1050, 0.2390, 0.3970, 0.0000, 0.1333], [1.0000, 0.4015, 0.4031, 0.2299, 0.1406, 0.2364, 0.1674, 0.1729, 0.3884], [1.0000, 0.0000, 0.2315, 0.0000, 0.1793, 0.1084, 0.0807, 0.0000, 0.1802], [1.0000, 0.2999, 0.6947, 0.3072, 0.4214, 0.3149, 0.1568, 0.2171, 0.5828], [1.0000, 0.3157, 0.3391, 0.4594, 0.4354, 0.3554, 0.2880, 0.2597, 0.4255], [1.0000, 0.5137, 0.6698, 0.7214, 0.5908, 0.5257, 0.5918, 0.4627, 0.6924], [1.0000, 0.0000, 0.3251, 0.2415, 0.3242, 0.3509, 0.4938, 0.1924, 0.6710], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0252, 0.5927, 0.0808, 0.4137, 0.4111, 0.6432, 0.0640, 0.1782], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1832, 0.1981, 0.2866, 0.2258, 0.1854, 0.1146, 0.1220, 0.3359], [1.0000, 0.0000, 0.0000, 0.1853, 0.1688, 0.3058, 0.6495, 0.0920, 0.0000], [1.0000, 0.4649, 0.3907, 0.6167, 0.3059, 0.3020, 0.3764, 0.3736, 0.4684], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0218, 0.3036, 0.0000, 0.0000], [1.0000, 0.0331, 0.0141, 0.0602, 0.0255, 0.0000, 0.0000, 0.0000, 0.0431], [1.0000, 0.0709, 0.1315, 0.1538, 0.1567, 0.1139, 0.0743, 0.1081, 0.1775], [1.0000, 0.5804, 0.5667, 0.5547, 0.4639, 0.2299, 0.4419, 0.4636, 0.6976], [1.0000, 0.4198, 0.3146, 0.2714, 0.6051, 0.1851, 0.4722, 0.0184, 0.5238], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1219], [1.0000, 0.1430, 0.3513, 0.1265, 0.6295, 0.5886, 0.7061, 0.2924, 0.1293], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0977, 0.1218, 0.1014, 0.0708, 0.0658, 0.1080, 0.0586, 0.0939], [1.0000, 0.8586, 0.8305, 0.8247, 0.7688, 0.6016, 0.8250, 0.5702, 0.8320], [1.0000, 0.0232, 0.4634, 0.3042, 0.2633, 0.3627, 0.6019, 0.1468, 0.3399], [1.0000, 0.7099, 0.7792, 0.6175, 0.4372, 0.3682, 0.4627, 0.1962, 0.7549], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.2152, 0.0000, 0.0200], [1.0000, 0.8918, 0.7712, 0.5734, 0.4910, 0.1624, 0.2850, 0.0486, 0.7471], [1.0000, 0.3900, 0.4205, 0.3976, 0.4165, 0.4283, 0.4218, 0.4199, 0.4279], [1.0000, 0.8003, 0.8291, 0.7628, 0.7961, 0.6919, 0.8268, 0.7240, 0.7750], [1.0000, 0.0547, 0.4972, 0.3272, 0.5648, 0.4325, 0.6035, 0.3278, 0.3710], [1.0000, 0.2024, 0.4078, 0.1650, 0.2796, 0.0697, 0.0091, 0.0000, 0.2649], [1.0000, 0.2236, 0.4679, 0.2564, 0.5632, 0.7561, 0.6947, 0.6096, 0.3835], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0081], [1.0000, 0.0365, 0.0227, 0.0452, 0.0382, 0.0746, 0.0455, 0.0646, 0.0547], [1.0000, 0.7032, 0.6459, 0.6764, 0.6397, 0.6799, 0.6622, 0.6166, 0.6986], [1.0000, 0.0973, 0.3050, 0.3034, 0.4468, 0.5415, 0.6006, 0.4896, 0.2852], [1.0000, 0.7886, 0.6708, 0.5633, 0.5756, 0.2515, 0.4278, 0.3229, 0.7357], [1.0000, 0.0000, 0.0000, 0.0823, 0.1509, 0.0962, 0.1969, 0.0000, 0.1862], [1.0000, 0.5161, 0.4578, 0.3733, 0.3599, 0.0228, 0.0000, 0.0423, 0.6970], [1.0000, 0.8317, 0.8375, 0.8474, 0.8510, 0.8430, 0.8154, 0.8367, 0.8437], [1.0000, 0.4569, 0.2800, 0.4156, 0.4128, 0.2035, 0.2168, 0.2684, 0.3462], [1.0000, 0.1035, 0.2278, 0.2320, 0.4749, 0.4772, 0.6669, 0.5081, 0.4475], [1.0000, 0.0328, 0.0422, 0.2180, 0.3399, 0.0000, 0.0000, 0.0000, 0.1790], [1.0000, 0.2864, 0.2543, 0.3412, 0.4784, 0.8237, 0.7166, 0.7772, 0.6858], [1.0000, 0.0000, 0.0000, 0.0526, 0.0132, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.1335, 0.1366, 0.1263, 0.1322, 0.1716, 0.1704, 0.1722, 0.1601], [1.0000, 0.6668, 0.6540, 0.6720, 0.6526, 0.6004, 0.6217, 0.6178, 0.6400], [1.0000, 0.4861, 0.4254, 0.4264, 0.5169, 0.3486, 0.7261, 0.6714, 0.5643], [1.0000, 0.7131, 0.6696, 0.5221, 0.4582, 0.4088, 0.5384, 0.6420, 0.7175], [1.0000, 0.0000, 0.0772, 0.1135, 0.2033, 0.0000, 0.1604, 0.1450, 0.1597], [1.0000, 0.1820, 0.6099, 0.0172, 0.1178, 0.0218, 0.0000, 0.1629, 0.0765], [1.0000, 0.4795, 0.4980, 0.4869, 0.5116, 0.5003, 0.5034, 0.5225, 0.5253], [1.0000, 0.3076, 0.1878, 0.1632, 0.1758, 0.0460, 0.0898, 0.1562, 0.1989], [1.0000, 0.4440, 0.4439, 0.6174, 0.5087, 0.6012, 0.7841, 0.7351, 0.5236], [1.0000, 0.2734, 0.1107, 0.1435, 0.0873, 0.0000, 0.0000, 0.0000, 0.1142], [1.0000, 0.2729, 0.5660, 0.4750, 0.5442, 0.4212, 0.7262, 0.8469, 0.6490], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3171, 0.3339, 0.3462, 0.3298, 0.3464, 0.3522, 0.3511, 0.3547], [1.0000, 0.2401, 0.2393, 0.2928, 0.2444, 0.2086, 0.2864, 0.2522, 0.2171], [1.0000, 0.4137, 0.5237, 0.4228, 0.5573, 0.4152, 0.7509, 0.5816, 0.6743], [1.0000, 0.1733, 0.0000, 0.0000, 0.0000, 0.0000, 0.1273, 0.0162, 0.0040], [1.0000, 0.0000, 0.0000, 0.0475, 0.0467, 0.1842, 0.3471, 0.0607, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0892, 0.0272, 0.0667, 0.0301, 0.0000, 0.0198, 0.0000, 0.0010], [1.0000, 0.3677, 0.4074, 0.4725, 0.3576, 0.4986, 0.4142, 0.4771, 0.2902], [1.0000, 0.5962, 0.9074, 0.5106, 0.4860, 0.6402, 0.8784, 0.7871, 0.7824], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3715, 0.9326, 0.6179, 0.5644, 0.5381, 0.9080, 0.8087, 0.8574], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3286, 0.3251, 0.3478, 0.3471, 0.3368, 0.3304, 0.3377, 0.3220], [1.0000, 0.3708, 0.3427, 0.3521, 0.3342, 0.3026, 0.3187, 0.3249, 0.2959], [1.0000, 0.6975, 0.8321, 0.5813, 0.6924, 0.2892, 0.7028, 0.5841, 0.6105], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0000, 0.0000, 0.1007, 0.0000, 0.0000, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0462, 0.1096, 0.1142, 0.1038, 0.0982, 0.1200, 0.1061, 0.0476], [1.0000, 0.1600, 0.2359, 0.2074, 0.3461, 0.3544, 0.0000, 0.2182, 0.1131], [1.0000, 0.8100, 0.9781, 0.5636, 0.8162, 0.4492, 0.8262, 0.7076, 0.8058], [1.0000, 0.4935, 0.5977, 0.5314, 0.8509, 0.7912, 0.3074, 0.6879, 0.2798], [1.0000, 0.2285, 0.8133, 0.5890, 0.5670, 0.0046, 0.5386, 0.3503, 0.3833], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.7418, 0.7447, 0.7409, 0.7205, 0.7408, 0.7403, 0.7394, 0.7044], [1.0000, 0.7034, 0.8831, 0.7683, 0.7588, 0.1745, 0.8636, 0.5444, 0.7526], [1.0000, 0.3803, 0.3617, 0.3153, 0.4358, 0.0351, 0.2294, 0.0000, 0.1432], [1.0000, 0.2064, 0.0000, 0.0000, 0.0000, 0.0000, 0.0085, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0320, 0.0326, 0.0116, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.4955, 0.6579, 0.6316, 0.5933, 0.5208, 0.6142, 0.4562, 0.5328], [1.0000, 0.7152, 0.8426, 0.8654, 0.6380, 0.0014, 0.6386, 0.4506, 0.7511], [1.0000, 0.2608, 0.6280, 0.6577, 0.6419, 0.4016, 0.4760, 0.2867, 0.2919], [1.0000, 0.6701, 1.0000, 0.8743, 0.7953, 0.1470, 0.7587, 0.5212, 0.7378], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4286, 0.4980, 0.4769, 0.5003, 0.4871, 0.4927, 0.4754, 0.4003], [1.0000, 0.5059, 0.8187, 0.7944, 0.7966, 0.4383, 0.9021, 0.4964, 0.5832], [1.0000, 0.0677, 0.0244, 0.2515, 0.3212, 0.0349, 0.3517, 0.0000, 0.0000], [1.0000, 0.7344, 0.0000, 0.4719, 0.3579, 0.0000, 0.3309, 0.0000, 0.0454], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.4905, 0.0000, 0.3020, 0.3893, 0.9837, 0.0000, 0.0000], [1.0000, 0.2768, 0.8438, 0.3351, 0.5603, 0.0000, 0.7092, 0.1068, 0.4485], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 1.0000, 0.6700, 0.8103, 0.9276, 0.6572, 0.7752, 0.5279, 0.6937], [1.0000, 0.8735, 0.0000, 0.7761, 1.0000, 0.0000, 0.3963, 0.0000, 0.0000], [1., 1., 1., 1., 1., 1., 1., 1., 1.], [1.0000, 0.4923, 0.0000, 0.1019, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.7474, 0.5581, 0.3530, 0.5412, 0.0000, 0.5699, 0.2909, 0.4315], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1187, 0.0302, 0.0000, 0.0806, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.2516, 0.6005, 0.2562, 0.7359, 0.0000, 0.5191, 0.0000, 0.2551], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.4004, 1.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    elif method == 'lw_adamergingpp' and model == 'ViT-B-16':
        # Layer-wise AdaMerging++ ViT-B/16
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.0000, 0.0000, 0.7314, 0.7737, 0.9137, 0.0000, 0.6581, 0.0000], [1.0000, 0.3260, 0.3443, 0.5687, 0.5706, 0.2529, 0.2593, 0.6055, 0.2540], [1.0000, 0.4704, 0.3928, 0.7666, 0.9242, 0.0000, 0.5162, 0.1448, 0.8359], [1.0000, 0.0000, 0.1092, 0.0000, 0.0000, 0.0000, 0.2517, 0.0543, 0.0789], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.5163, 0.4132, 0.0367, 0.2204, 0.6727, 0.6710, 0.4261, 0.0808], [1.0000, 0.2529, 0.2111, 0.2852, 0.2641, 0.2137, 0.2173, 0.4818, 0.3695], [1.0000, 0.2271, 0.2091, 0.2683, 0.3082, 0.3695, 0.4609, 0.4045, 0.3167], [1.0000, 0.2883, 0.1711, 0.2539, 0.1371, 0.3157, 0.4596, 0.5461, 0.0780], [1.0000, 0.0244, 0.0000, 0.0000, 0.0000, 0.1663, 0.3268, 0.1331, 0.0000], [1.0000, 0.0840, 0.1725, 0.0000, 0.0894, 0.2816, 0.4619, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1077, 0.1466, 0.2412, 0.0000], [1.0000, 0.0000, 0.0439, 0.0000, 0.0000, 0.1095, 0.1368, 0.2085, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2670, 0.0440, 0.3325, 0.5172, 0.4593, 0.5609, 0.2740, 0.1398], [1.0000, 0.2945, 0.1680, 0.4028, 0.4969, 0.3714, 0.3168, 0.2090, 0.3765], [1.0000, 0.0573, 0.0094, 0.0000, 0.0624, 0.1895, 0.0000, 0.0000, 0.0000], [1.0000, 0.7501, 0.6819, 0.2780, 0.5542, 0.5385, 0.4384, 0.1404, 0.4649], [1.0000, 0.3443, 0.3340, 0.3156, 0.3354, 0.3724, 0.3204, 0.3437, 0.3913], [1.0000, 0.3334, 0.2883, 0.2401, 0.2654, 0.3184, 0.2509, 0.3055, 0.2512], [1.0000, 0.3503, 0.2338, 0.2018, 0.2652, 0.5025, 0.4090, 0.4232, 0.5077], [1.0000, 0.1215, 0.1096, 0.0000, 0.0493, 0.1563, 0.0000, 0.0163, 0.0506], [1.0000, 0.2119, 0.3994, 0.0496, 0.4122, 0.6661, 0.6347, 0.5092, 0.2826], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1162, 0.0000, 0.0000, 0.0000], [1.0000, 0.2596, 0.2376, 0.2369, 0.2810, 0.1996, 0.2475, 0.2620, 0.1922], [1.0000, 0.1238, 0.0454, 0.0000, 0.3883, 0.4121, 0.3373, 0.1997, 0.0000], [1.0000, 0.0766, 0.2944, 0.0000, 0.4622, 0.3784, 0.6695, 0.0660, 0.0000], [1.0000, 0.7541, 0.8145, 0.7035, 0.8165, 0.7386, 0.7547, 0.7018, 0.6482], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.2705, 0.3081, 0.0000, 0.0000], [1.0000, 0.3989, 0.0869, 0.0921, 0.5951, 0.6566, 0.5427, 0.3538, 0.0000], [1.0000, 0.4955, 0.4092, 0.5062, 0.5067, 0.5331, 0.5460, 0.4848, 0.5133], [1.0000, 0.1540, 0.2626, 0.2014, 0.1778, 0.1843, 0.1402, 0.0864, 0.1666], [1.0000, 0.4677, 0.3446, 0.2346, 0.3916, 0.6161, 0.7686, 0.3990, 0.4408], [1.0000, 0.1516, 0.1639, 0.1417, 0.1123, 0.1408, 0.2001, 0.0000, 0.2122], [1.0000, 0.1556, 0.1447, 0.0000, 0.3256, 0.4604, 0.6716, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0351, 0.4164, 0.0936, 0.3534, 0.6427, 0.6554, 0.5010, 0.2065], [1.0000, 0.0108, 0.3084, 0.0000, 0.0861, 0.2338, 0.5906, 0.0000, 0.0000], [1.0000, 0.6746, 0.5484, 0.2357, 0.3283, 0.5138, 0.3677, 0.2721, 0.5264], [1.0000, 0.0000, 0.2331, 0.0000, 0.2468, 0.3555, 0.5977, 0.0000, 0.0168], [1.0000, 0.4182, 0.5874, 0.3533, 0.6123, 0.7851, 0.5531, 0.8345, 0.3663], [1.0000, 0.2206, 0.2446, 0.3649, 0.3405, 0.2501, 0.1881, 0.1516, 0.3202], [1.0000, 0.7553, 0.7863, 0.6576, 0.6601, 0.8738, 0.9292, 0.5526, 0.7842], [1.0000, 0.0000, 0.4957, 0.1049, 0.3444, 0.3791, 0.6532, 0.1565, 0.7490], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0222, 0.6646, 0.0000, 0.4673, 0.4405, 0.8037, 0.0000, 0.2144], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0357, 0.2071, 0.0395, 0.1825, 0.0159, 0.0734, 0.0000, 0.1489], [1.0000, 0.0651, 0.2510, 0.0488, 0.2544, 0.3912, 0.8472, 0.0000, 0.0000], [1.0000, 0.1293, 0.2545, 0.2531, 0.1002, 0.3049, 0.4351, 0.2786, 0.2695], [1.0000, 0.0000, 0.0000, 0.0000, 0.0408, 0.2580, 0.6949, 0.0000, 0.0000], [1.0000, 0.8102, 0.8128, 0.7020, 0.7040, 0.6873, 0.5125, 0.5917, 0.5622], [1.0000, 0.0000, 0.0037, 0.0263, 0.0301, 0.0055, 0.0000, 0.0000, 0.0420], [1.0000, 0.6896, 0.5679, 0.5120, 0.6146, 0.5420, 0.6666, 0.5665, 0.6215], [1.0000, 0.3692, 0.1492, 0.1204, 0.6329, 0.1884, 0.6600, 0.0000, 0.6168], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1140], [1.0000, 0.1158, 0.3052, 0.2493, 0.6407, 0.6348, 0.8841, 0.1699, 0.2688], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1534, 0.1936, 0.1602, 0.1132, 0.1154, 0.1734, 0.1200, 0.1632], [1.0000, 0.7844, 0.7296, 0.6135, 0.6326, 0.5326, 0.7209, 0.6027, 0.6971], [1.0000, 0.0523, 0.5615, 0.4448, 0.3179, 0.3254, 0.8026, 0.1278, 0.5242], [1.0000, 0.5798, 0.8845, 0.4044, 0.3370, 0.2498, 0.6020, 0.0179, 0.6878], [1.0000, 0.0000, 0.0000, 0.0508, 0.1791, 0.0573, 0.6241, 0.0000, 0.0000], [1.0000, 1.0000, 1.0000, 1.0000, 0.9045, 0.4037, 1.0000, 0.6451, 1.0000], [1.0000, 0.4303, 0.4607, 0.4188, 0.4281, 0.4772, 0.4862, 0.4638, 0.4452], [1.0000, 0.5547, 0.5678, 0.4872, 0.5220, 0.5143, 0.6333, 0.4811, 0.4849], [1.0000, 0.2491, 0.5323, 0.2867, 0.5140, 0.4405, 0.8440, 0.3259, 0.5633], [1.0000, 0.3829, 0.4398, 0.3606, 0.2917, 0.3602, 0.4395, 0.1527, 0.3588], [1.0000, 0.4252, 0.6655, 0.2655, 0.6053, 0.6994, 0.8887, 0.6328, 0.5608], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1836, 0.1726, 0.2120, 0.1999, 0.2466, 0.2234, 0.2373, 0.2246], [1.0000, 0.4917, 0.4750, 0.5556, 0.5651, 0.5372, 0.5673, 0.4939, 0.5429], [1.0000, 0.2012, 0.8141, 0.3538, 0.5109, 0.5905, 0.8299, 0.4881, 0.5159], [1.0000, 0.4261, 0.4294, 0.4760, 0.4969, 0.3263, 0.5915, 0.2043, 0.4418], [1.0000, 0.0000, 0.1167, 0.1567, 0.4421, 0.3820, 0.6699, 0.2677, 0.3302], [1.0000, 0.6207, 0.5254, 0.4311, 0.9012, 0.6828, 1.0000, 0.3950, 0.9271], [1.0000, 0.8812, 0.9036, 0.8867, 0.9016, 0.9615, 0.9159, 0.9095, 0.8990], [1.0000, 0.3457, 0.2711, 0.2451, 0.3506, 0.1516, 0.1425, 0.2622, 0.2403], [1.0000, 0.2082, 0.5607, 0.2292, 0.4131, 0.4840, 0.8714, 0.4967, 0.5634], [1.0000, 0.0335, 0.0840, 0.0114, 0.0000, 0.0000, 0.1358, 0.0000, 0.0635], [1.0000, 0.4743, 0.6353, 0.5095, 0.4811, 0.7496, 0.9110, 0.8393, 0.8340], [1.0000, 0.0000, 0.0000, 0.0666, 0.0000, 0.0000, 0.0590, 0.0000, 0.0000], [1.0000, 0.2935, 0.2784, 0.2708, 0.2783, 0.3124, 0.3264, 0.3134, 0.3053], [1.0000, 0.6648, 0.6797, 0.6953, 0.6925, 0.6172, 0.6609, 0.6387, 0.6876], [1.0000, 0.7323, 0.8591, 0.5798, 0.6022, 0.3835, 0.9310, 0.8017, 0.8514], [1.0000, 0.6571, 0.6694, 0.5101, 0.5571, 0.5593, 0.7003, 0.7709, 0.8177], [1.0000, 0.0000, 0.2192, 0.3695, 0.4412, 0.1491, 0.5959, 0.4206, 0.4388], [1.0000, 0.2328, 1.0000, 0.6564, 0.7819, 0.8658, 0.1828, 1.0000, 0.3122], [1.0000, 0.4688, 0.5309, 0.4896, 0.5113, 0.5059, 0.5409, 0.5635, 0.5522], [1.0000, 0.0591, 0.0943, 0.2004, 0.1872, 0.0138, 0.1505, 0.2414, 0.0559], [1.0000, 0.6898, 0.8749, 0.8156, 0.6319, 0.7320, 0.9620, 0.8180, 0.7471], [1.0000, 0.2466, 0.2291, 0.2273, 0.1433, 0.2179, 0.2918, 0.1695, 0.1196], [1.0000, 0.3353, 0.6906, 0.7308, 0.6923, 0.7001, 0.9402, 0.9545, 0.8342], [1.0000, 0.1722, 0.3730, 0.2555, 0.0000, 0.0000, 0.1889, 0.3167, 0.0000], [1.0000, 0.4145, 0.4064, 0.4246, 0.3994, 0.4199, 0.4249, 0.4346, 0.4377], [1.0000, 0.0000, 0.0154, 0.0947, 0.0517, 0.0414, 0.0702, 0.0526, 0.0000], [1.0000, 0.5874, 0.8336, 0.6328, 0.6897, 0.4625, 0.9105, 0.7006, 0.8706], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.1818, 0.3974, 0.3258, 0.2558, 0.6428, 0.2759, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1138, 0.0621, 0.0940, 0.0577, 0.0183, 0.0593, 0.0322, 0.0329], [1.0000, 0.3055, 0.3422, 0.5386, 0.1787, 0.2284, 0.2472, 0.3869, 0.2174], [1.0000, 0.7302, 1.0000, 0.8608, 0.8356, 0.6858, 1.0000, 0.9179, 1.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.7661, 1.0000, 0.8803, 0.8405, 0.7056, 1.0000, 1.0000, 1.0000], [1.0000, 0.0000, 0.0000, 0.0237, 0.0000, 0.0000, 0.0000, 0.5083, 0.0000], [1.0000, 0.5999, 0.5939, 0.6102, 0.6145, 0.5971, 0.5923, 0.5954, 0.5875], [1.0000, 0.1274, 0.1486, 0.1197, 0.1165, 0.0704, 0.0946, 0.1235, 0.0540], [1.0000, 0.9694, 1.0000, 0.7081, 0.8282, 0.3563, 0.8823, 0.4892, 0.8813], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0000, 0.0000, 0.2478, 0.0000, 0.2423, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0000, 0.0582, 0.0319, 0.0234, 0.0535, 0.0439, 0.0000], [1.0000, 0.0413, 0.1304, 0.2087, 0.1748, 0.1499, 0.0000, 0.1355, 0.0398], [1.0000, 1.0000, 1.0000, 0.9063, 0.9412, 0.7777, 0.9934, 0.9291, 1.0000], [1.0000, 0.5538, 0.5822, 0.5132, 0.6184, 0.5916, 0.4178, 0.6159, 0.4319], [1.0000, 0.5175, 1.0000, 0.8696, 0.8225, 0.2802, 0.7645, 0.5187, 0.7586], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1803, 0.1358, 0.1365, 0.1744, 0.1353, 0.1585, 0.1457, 0.1843], [1.0000, 0.6167, 0.6113, 0.6074, 0.5903, 0.5935, 0.6058, 0.5977, 0.5588], [1.0000, 1.0000, 1.0000, 0.9946, 1.0000, 0.1496, 0.9753, 0.6590, 0.9873], [1.0000, 0.3985, 0.3609, 0.2393, 0.5096, 0.0000, 0.4302, 0.0807, 0.1936], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1236, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.0698, 0.0164, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.4515, 0.5601, 0.5873, 0.5518, 0.3667, 0.5583, 0.4011, 0.4716], [1.0000, 1.0000, 1.0000, 1.0000, 0.8612, 0.0000, 0.7910, 0.5431, 1.0000], [1.0000, 0.5865, 0.7956, 0.7891, 0.8958, 0.6311, 0.6343, 0.6358, 0.5849], [1.0000, 0.9902, 1.0000, 1.0000, 0.9946, 0.0754, 0.9644, 0.5531, 1.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.4514, 0.0000, 0.0000, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3898, 0.4714, 0.4583, 0.4806, 0.4569, 0.4698, 0.4488, 0.3821], [1.0000, 0.6646, 1.0000, 0.9573, 1.0000, 0.3285, 0.9948, 0.2995, 0.8074], [1.0000, 0.0000, 0.0000, 0.2410, 0.2963, 0.0525, 0.3630, 0.0000, 0.0000], [1.0000, 0.7129, 0.0000, 0.5448, 0.6077, 0.0000, 0.4594, 0.0000, 0.1386], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0000, 0.7641, 0.0000, 0.6716, 0.6092, 1.0000, 0.2720, 0.1051], [1.0000, 0.3122, 0.9721, 0.3283, 0.8624, 0.0000, 0.8286, 0.0000, 0.4449], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.5137, 0.9581, 0.4913, 0.9771], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.0000, 0.7950], [1., 1., 1., 1., 1., 1., 1., 1., 1.], [1.0000, 0.2195, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.7103, 0.5987, 0.3682, 0.7250, 0.0000, 0.5075, 0.0043, 0.5197], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.0186, 0.0000, 0.0515, 0.4694, 0.0000, 0.0000, 0.0000, 0.1592], [1.0000, 0.0000, 0.4621, 0.0331, 0.6501, 0.1928, 0.7597, 0.0000, 0.2514], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.8428, 1.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    # 'ViT-L-14'
    elif method == 'lw_adamerging' and model == 'ViT-L-14':
        # Layer-wise AdaMerging ViT-L/14
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.1337, 0.1739, 0.2253, 0.2303, 0.2185, 0.2218, 0.2032, 0.1953], [1.0000, 0.2536, 0.3060, 0.2170, 0.3645, 0.2957, 0.3466, 0.2166, 0.1896], [1.0000, 0.9326, 0.8400, 0.7822, 0.7381, 0.0000, 0.7731, 0.3292, 1.0000], [1.0000, 0.1714, 0.2602, 0.0000, 0.2115, 0.1927, 0.2804, 0.1350, 0.2309], [1.0000, 0.0858, 0.1104, 0.0000, 0.0000, 0.1087, 0.1966, 0.1727, 0.1383], [1.0000, 0.2457, 0.2348, 0.0769, 0.2955, 0.4253, 0.4081, 0.2276, 0.1135], [1.0000, 0.2215, 0.1849, 0.1917, 0.2594, 0.2457, 0.2123, 0.1874, 0.1961], [1.0000, 0.1992, 0.1825, 0.2992, 0.3766, 0.3808, 0.3339, 0.2605, 0.2916], [1.0000, 0.0738, 0.0000, 0.0470, 0.1573, 0.1956, 0.0000, 0.0793, 0.0241], [1.0000, 0.0359, 0.0478, 0.0578, 0.2382, 0.2593, 0.1090, 0.0771, 0.0073], [1.0000, 0.1418, 0.0775, 0.0439, 0.2597, 0.2627, 0.2213, 0.1151, 0.0000], [1.0000, 0.0897, 0.2098, 0.0633, 0.2710, 0.4405, 0.3634, 0.1815, 0.0704], [1.0000, 0.5280, 0.5634, 0.5259, 0.4152, 0.5262, 0.5619, 0.5855, 0.4920], [1.0000, 0.0000, 0.1036, 0.0245, 0.0535, 0.0124, 0.1140, 0.1628, 0.0234], [1.0000, 0.0036, 0.2079, 0.0837, 0.0928, 0.0210, 0.2423, 0.0627, 0.0808], [1.0000, 0.3935, 0.4163, 0.3802, 0.3924, 0.3432, 0.4726, 0.3513, 0.4034], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1374, 0.0346, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0348, 0.2523, 0.0843, 0.0000], [1.0000, 0.3421, 0.2031, 0.1182, 0.1598, 0.2580, 0.2715, 0.1817, 0.1786], [1.0000, 0.1707, 0.0000, 0.1353, 0.1183, 0.0991, 0.1732, 0.0669, 0.0790], [1.0000, 0.2194, 0.1378, 0.2225, 0.2555, 0.1576, 0.0573, 0.1617, 0.1365], [1.0000, 0.1427, 0.0063, 0.2007, 0.1574, 0.2161, 0.3810, 0.1533, 0.1951], [1.0000, 0.1647, 0.1121, 0.1253, 0.2032, 0.1805, 0.1760, 0.1255, 0.1898], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0745, 0.2159, 0.0357, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0235, 0.0000], [1.0000, 0.0000, 0.0000, 0.0137, 0.0392, 0.0385, 0.0000, 0.0798, 0.0000], [1.0000, 0.1588, 0.1116, 0.1411, 0.2943, 0.3425, 0.3848, 0.2254, 0.1142], [1.0000, 0.0387, 0.0000, 0.0289, 0.0960, 0.1183, 0.1582, 0.1036, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1102, 0.2181, 0.0000, 0.0000], [1.0000, 0.1133, 0.2047, 0.0000, 0.0000, 0.4527, 0.4850, 0.0000, 0.0000], [1.0000, 0.2225, 0.2676, 0.2232, 0.2366, 0.2699, 0.2419, 0.2269, 0.2587], [1.0000, 0.0911, 0.2651, 0.1381, 0.0768, 0.2150, 0.2608, 0.0636, 0.1020], [1.0000, 0.1173, 0.0279, 0.0994, 0.0903, 0.3623, 0.3540, 0.1983, 0.2463], [1.0000, 0.1699, 0.2640, 0.1349, 0.0794, 0.2083, 0.2447, 0.1200, 0.1591], [1.0000, 0.0635, 0.0132, 0.0000, 0.0879, 0.2806, 0.3558, 0.0000, 0.1065], [1.0000, 0.1011, 0.2361, 0.0000, 0.0000, 0.3656, 0.4710, 0.0471, 0.0242], [1.0000, 0.0301, 0.0700, 0.0106, 0.0424, 0.1212, 0.0557, 0.0271, 0.0378], [1.0000, 0.1294, 0.4752, 0.0770, 0.2668, 0.5202, 0.4964, 0.4278, 0.4100], [1.0000, 0.0110, 0.0028, 0.0000, 0.1568, 0.2478, 0.0000, 0.0462, 0.0371], [1.0000, 0.5561, 0.5007, 0.5042, 0.4962, 0.4880, 0.4093, 0.5005, 0.5839], [1.0000, 0.0588, 0.0000, 0.0000, 0.0000, 0.0000, 0.1958, 0.0000, 0.0027], [1.0000, 0.2158, 0.1210, 0.0000, 0.0184, 0.0851, 0.3735, 0.0000, 0.1779], [1.0000, 0.5890, 0.5978, 0.6068, 0.5801, 0.5858, 0.5961, 0.5751, 0.5639], [1.0000, 0.1409, 0.1469, 0.0615, 0.0619, 0.0978, 0.1850, 0.1243, 0.1146], [1.0000, 0.1102, 0.1383, 0.2917, 0.3260, 0.4217, 0.5691, 0.1575, 0.1462], [1.0000, 0.1167, 0.1975, 0.0840, 0.0529, 0.1714, 0.3139, 0.1605, 0.1050], [1.0000, 0.3096, 0.1260, 0.2910, 0.3642, 0.4658, 0.6021, 0.1773, 0.2114], [1.0000, 0.1764, 0.2347, 0.1254, 0.1356, 0.3101, 0.4394, 0.1603, 0.2069], [1.0000, 0.3007, 0.3202, 0.2422, 0.3241, 0.2791, 0.3257, 0.3049, 0.3131], [1.0000, 0.2506, 0.1338, 0.3300, 0.2989, 0.4159, 0.3892, 0.4054, 0.1386], [1.0000, 0.2327, 0.1697, 0.0749, 0.4390, 0.3990, 0.3916, 0.0000, 0.0014], [1.0000, 0.2734, 0.2723, 0.1767, 0.2735, 0.2860, 0.2976, 0.2011, 0.1728], [1.0000, 0.0000, 0.1449, 0.0000, 0.0000, 0.1519, 0.0889, 0.0000, 0.0000], [1.0000, 0.3404, 0.5584, 0.1713, 0.1560, 0.4345, 0.4368, 0.1858, 0.2559], [1.0000, 0.3354, 0.3413, 0.2718, 0.2716, 0.2872, 0.2675, 0.3127, 0.2625], [1.0000, 0.4442, 0.1946, 0.2956, 0.3303, 0.3442, 0.4705, 0.1751, 0.4720], [1.0000, 0.2146, 0.2519, 0.3556, 0.3901, 0.4645, 0.5429, 0.2329, 0.2449], [1.0000, 0.3658, 0.1860, 0.1208, 0.2082, 0.3305, 0.3650, 0.1199, 0.3307], [1.0000, 0.1436, 0.1097, 0.2487, 0.2923, 0.2961, 0.4014, 0.0246, 0.1670], [1.0000, 0.3623, 0.3149, 0.1257, 0.2908, 0.3703, 0.4047, 0.1005, 0.3507], [1.0000, 0.2851, 0.3161, 0.2837, 0.2641, 0.3197, 0.3120, 0.2904, 0.2572], [1.0000, 0.3040, 0.2118, 0.2501, 0.0000, 0.2996, 0.4379, 0.2180, 0.2299], [1.0000, 0.3017, 0.1128, 0.2007, 0.3504, 0.3502, 0.4609, 0.0281, 0.0722], [1.0000, 0.4443, 0.3402, 0.4068, 0.3754, 0.3662, 0.3977, 0.3619, 0.4332], [1.0000, 0.0354, 0.0000, 0.0000, 0.0000, 0.1496, 0.1163, 0.0000, 0.0000], [1.0000, 0.2193, 0.1569, 0.1277, 0.0455, 0.2191, 0.1772, 0.0489, 0.1046], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4900, 0.3938, 0.2716, 0.2674, 0.3455, 0.2395, 0.3418, 0.4173], [1.0000, 0.0000, 0.1287, 0.0721, 0.3379, 0.4584, 0.3718, 0.0000, 0.0514], [1.0000, 0.3154, 0.2265, 0.0125, 0.1689, 0.2748, 0.1677, 0.1797, 0.0921], [1.0000, 0.0862, 0.0288, 0.1318, 0.3117, 0.4827, 0.6141, 0.1061, 0.3017], [1.0000, 0.4664, 0.2931, 0.1383, 0.2267, 0.4743, 0.4424, 0.1652, 0.2847], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4313, 0.3627, 0.3865, 0.3705, 0.5120, 0.4501, 0.1133, 0.5268], [1.0000, 0.0000, 0.0000, 0.0000, 0.0682, 0.1573, 0.1513, 0.0000, 0.0833], [1.0000, 0.6041, 0.4499, 0.3902, 0.3811, 0.3552, 0.3576, 0.2521, 0.5869], [1.0000, 0.1088, 0.0000, 0.0000, 0.0921, 0.3314, 0.2944, 0.0000, 0.0679], [1.0000, 0.1997, 0.2071, 0.0000, 0.1772, 0.3281, 0.2129, 0.0583, 0.1405], [1.0000, 0.2823, 0.2981, 0.2852, 0.2722, 0.3206, 0.3099, 0.3199, 0.2679], [1.0000, 0.2794, 0.1120, 0.0000, 0.0256, 0.1197, 0.1563, 0.0739, 0.1965], [1.0000, 0.1359, 0.0538, 0.0000, 0.0817, 0.3511, 0.4642, 0.0474, 0.1289], [1.0000, 0.3320, 0.1807, 0.0000, 0.0000, 0.1189, 0.2195, 0.0397, 0.1625], [1.0000, 0.2036, 0.0299, 0.1560, 0.2135, 0.3646, 0.5281, 0.0432, 0.1468], [1.0000, 0.4741, 0.3846, 0.0000, 0.1465, 0.3302, 0.3618, 0.0808, 0.3755], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1821, 0.1963, 0.0000, 0.0000, 0.0000, 0.1842, 0.0000, 0.0868], [1.0000, 0.0211, 0.1882, 0.0000, 0.0000, 0.2647, 0.5799, 0.0000, 0.3627], [1.0000, 0.2976, 0.3561, 0.1324, 0.0000, 0.1747, 0.4235, 0.0000, 0.4340], [1.0000, 0.0000, 0.0596, 0.0000, 0.0000, 0.0082, 0.3963, 0.0000, 0.1179], [1.0000, 0.0000, 0.0342, 0.0000, 0.0000, 0.0000, 0.0349, 0.0000, 0.0000], [1.0000, 0.0762, 0.0778, 0.0694, 0.0696, 0.0441, 0.0622, 0.0570, 0.0586], [1.0000, 0.3244, 0.3028, 0.1345, 0.0965, 0.1104, 0.2003, 0.0736, 0.3882], [1.0000, 0.1013, 0.2072, 0.0811, 0.1413, 0.1784, 0.3776, 0.0896, 0.2913], [1.0000, 0.3079, 0.3867, 0.1477, 0.1856, 0.1734, 0.2843, 0.2184, 0.2916], [1.0000, 0.1751, 0.2054, 0.0690, 0.2881, 0.4448, 0.5667, 0.0705, 0.0607], [1.0000, 0.2463, 0.2589, 0.0000, 0.0000, 0.1330, 0.2110, 0.0000, 0.2635], [1.0000, 0.0757, 0.0862, 0.0888, 0.0871, 0.0781, 0.1101, 0.0954, 0.0943], [1.0000, 0.0243, 0.0000, 0.0000, 0.0000, 0.0000, 0.0127, 0.0000, 0.0000], [1.0000, 0.0000, 0.1504, 0.0000, 0.0928, 0.3680, 0.5937, 0.0000, 0.0357], [1.0000, 0.1691, 0.2878, 0.0253, 0.0000, 0.2016, 0.3237, 0.0335, 0.2293], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.3202, 0.3907, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1208, 0.0623, 0.0000, 0.0000], [1.0000, 0.1572, 0.1331, 0.1326, 0.1193, 0.1709, 0.1670, 0.1454, 0.1600], [1.0000, 0.3821, 0.2909, 0.0937, 0.1674, 0.4058, 0.3040, 0.2872, 0.1672], [1.0000, 0.3194, 0.0691, 0.0729, 0.1483, 0.4499, 0.5441, 0.1813, 0.2625], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3192, 0.1226, 0.1247, 0.3338, 0.5009, 0.6697, 0.2780, 0.0000], [1.0000, 0.0229, 0.0388, 0.0000, 0.0000, 0.1334, 0.1276, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2996, 0.2308, 0.2172, 0.2969, 0.2790, 0.3222, 0.2994, 0.3224], [1.0000, 0.0075, 0.0585, 0.0530, 0.2273, 0.4015, 0.5406, 0.1667, 0.2254], [1.0000, 0.3419, 0.3203, 0.1699, 0.1651, 0.2869, 0.3580, 0.2680, 0.4364], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0570, 0.2450, 0.0000, 0.0000], [1.0000, 0.0351, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0588, 0.0343], [1.0000, 0.2301, 0.2705, 0.2235, 0.2336, 0.2514, 0.2391, 0.2536, 0.2553], [1.0000, 0.4356, 0.4859, 0.3192, 0.2623, 0.2788, 0.2729, 0.3045, 0.3929], [1.0000, 0.4035, 0.2450, 0.1126, 0.3243, 0.4207, 0.5124, 0.4062, 0.2120], [1.0000, 0.2539, 0.2569, 0.0509, 0.0136, 0.0968, 0.1998, 0.1785, 0.1710], [1.0000, 0.1337, 0.0000, 0.1370, 0.4963, 0.5262, 0.6210, 0.3926, 0.0000], [1.0000, 0.0000, 0.1702, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.1892, 0.2077, 0.2093, 0.1983, 0.2048, 0.2076, 0.2152, 0.1973], [1.0000, 0.1327, 0.0586, 0.0276, 0.0000, 0.0328, 0.0621, 0.0544, 0.0926], [1.0000, 0.2010, 0.0174, 0.0000, 0.3116, 0.5159, 0.5923, 0.2843, 0.0758], [1.0000, 0.3977, 0.2145, 0.0000, 0.1353, 0.1028, 0.3029, 0.1608, 0.1150], [1.0000, 0.0000, 0.0000, 0.0000, 0.0150, 0.0000, 0.3972, 0.0000, 0.0000], [1.0000, 0.4632, 0.2289, 0.0000, 0.0801, 0.0000, 0.2744, 0.0732, 0.2270], [1.0000, 0.0523, 0.0368, 0.0402, 0.0590, 0.0636, 0.0519, 0.0557, 0.0309], [1.0000, 0.5057, 0.3944, 0.4195, 0.4790, 0.3110, 0.4597, 0.3237, 0.5118], [1.0000, 0.2340, 0.3435, 0.1427, 0.4644, 0.6059, 0.5934, 0.4417, 0.3623], [1.0000, 0.0543, 0.0390, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.0533, 0.0125, 0.3497, 0.4732, 0.5614, 0.6478, 0.6125, 0.2723], [1.0000, 0.4862, 0.3779, 0.0000, 0.0337, 0.0000, 0.1374, 0.0638, 0.0000], [1.0000, 0.0480, 0.0273, 0.0000, 0.0255, 0.0000, 0.0166, 0.0350, 0.0468], [1.0000, 0.4794, 0.4641, 0.3746, 0.4223, 0.3017, 0.3822, 0.3224, 0.3910], [1.0000, 0.1624, 0.3655, 0.3025, 0.3848, 0.4488, 0.6277, 0.3358, 0.5562], [1.0000, 0.5096, 0.6824, 0.4281, 0.4183, 0.0811, 0.5308, 0.2393, 0.5844], [1.0000, 0.1138, 0.0000, 0.0445, 0.0374, 0.0000, 0.3398, 0.0080, 0.1023], [1.0000, 0.4629, 0.1626, 0.0913, 0.0206, 0.0000, 0.0578, 0.0000, 0.1765], [1.0000, 0.2816, 0.2808, 0.2848, 0.2755, 0.2539, 0.2675, 0.2681, 0.2759], [1.0000, 0.2470, 0.2531, 0.3174, 0.2116, 0.1373, 0.1808, 0.2701, 0.2303], [1.0000, 0.1730, 0.3304, 0.4311, 0.4494, 0.6123, 0.5358, 0.4233, 0.2900], [1.0000, 0.1500, 0.0529, 0.1847, 0.0325, 0.0000, 0.0496, 0.1202, 0.0000], [1.0000, 0.0100, 0.4324, 0.3443, 0.4103, 0.7160, 0.6274, 0.6316, 0.3548], [1.0000, 0.2913, 0.1395, 0.1065, 0.0000, 0.0000, 0.0806, 0.0000, 0.1077], [1.0000, 0.1734, 0.2047, 0.1556, 0.1518, 0.1754, 0.2005, 0.1973, 0.1537], [1.0000, 0.3493, 0.2880, 0.3174, 0.2496, 0.2606, 0.2922, 0.2944, 0.3138], [1.0000, 0.0350, 0.2573, 0.0621, 0.1978, 0.5556, 0.5940, 0.3812, 0.3323], [1.0000, 0.2327, 0.2046, 0.0565, 0.0763, 0.1030, 0.3532, 0.0912, 0.2744], [1.0000, 0.0931, 0.0000, 0.0000, 0.0000, 0.0000, 0.3744, 0.0000, 0.2287], [1.0000, 0.2321, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1186], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2187, 0.1751, 0.1868, 0.1928, 0.2288, 0.0197, 0.2677, 0.2855], [1.0000, 0.4071, 0.2425, 0.2845, 0.3572, 0.5644, 0.5959, 0.3567, 0.3125], [1.0000, 0.4446, 0.2926, 0.3204, 0.2562, 0.2259, 0.3425, 0.2864, 0.4333], [1.0000, 0.2678, 0.5125, 0.2527, 0.4170, 0.6935, 0.6824, 0.7532, 0.6608], [1.0000, 0.2149, 0.0000, 0.0000, 0.0000, 0.0000, 0.0916, 0.0000, 0.2316], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2355, 0.2310, 0.2310, 0.1946, 0.2267, 0.2059, 0.2045, 0.2775], [1.0000, 0.2148, 0.2424, 0.2203, 0.3089, 0.4578, 0.5983, 0.3502, 0.7129], [1.0000, 0.3417, 0.3035, 0.1916, 0.1566, 0.1386, 0.3899, 0.0593, 0.4582], [1.0000e+00, 3.3355e-04, 6.5439e-03, 3.8669e-02, 0.0000e+00, 0.0000e+00, 3.5903e-01, 0.0000e+00, 2.9245e-01], [1.0000, 0.2010, 0.0438, 0.0000, 0.0000, 0.0000, 0.0570, 0.0000, 0.1484], [1.0000, 0.5503, 0.5450, 0.5083, 0.5409, 0.5663, 0.5427, 0.5383, 0.5430], [1.0000, 0.4723, 0.3858, 0.3467, 0.2883, 0.2921, 0.5413, 0.3283, 0.3965], [1.0000, 0.1299, 0.3632, 0.2335, 0.3063, 0.6983, 0.6305, 0.7054, 0.5458], [1.0000, 0.3151, 0.2449, 0.2604, 0.0777, 0.1310, 0.4798, 0.1874, 0.2963], [1.0000, 0.2980, 0.5388, 0.5241, 0.5088, 0.5107, 0.7003, 0.6691, 0.7140], [1.0000, 0.0655, 0.0000, 0.1013, 0.0000, 0.0000, 0.2539, 0.0000, 0.3540], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4525, 0.4124, 0.4203, 0.3824, 0.4046, 0.5050, 0.4140, 0.4808], [1.0000, 0.5026, 0.6676, 0.4748, 0.3364, 0.5206, 0.6857, 0.4171, 0.8444], [1.0000, 0.6547, 0.5443, 0.4245, 0.3240, 0.3407, 0.5494, 0.2921, 0.7060], [1.0000, 0.3144, 0.2247, 0.1477, 0.0718, 0.1631, 0.4611, 0.1396, 0.5509], [1.0000, 0.2024, 0.1221, 0.0000, 0.0000, 0.0486, 0.0423, 0.0000, 0.2487], [1.0000, 0.9906, 0.9810, 0.9765, 0.9736, 0.9719, 0.9963, 0.9818, 0.9744], [1.0000, 0.3376, 0.2839, 0.1374, 0.2542, 0.2779, 0.2939, 0.1748, 0.2684], [1.0000, 0.4501, 0.7341, 0.4811, 0.4350, 0.5855, 0.7211, 0.4820, 0.7303], [1.0000, 0.2437, 0.1941, 0.1233, 0.2317, 0.2089, 0.1958, 0.2100, 0.3736], [1.0000, 0.6178, 0.8567, 0.6339, 0.5765, 0.5983, 0.7679, 0.5553, 0.8621], [1.0000, 0.2419, 0.0000, 0.0294, 0.0000, 0.0366, 0.1255, 0.0000, 0.2472], [1.0000, 0.1752, 0.1578, 0.1582, 0.1615, 0.1586, 0.1894, 0.1699, 0.1842], [1.0000, 0.3931, 0.3403, 0.3613, 0.3715, 0.3628, 0.3986, 0.3546, 0.3824], [1.0000, 0.5186, 0.8015, 0.5793, 0.5064, 0.4606, 0.7205, 0.5440, 0.7433], [1.0000, 0.4866, 0.4936, 0.3562, 0.4569, 0.1454, 0.5417, 0.2880, 0.3478], [1.0000, 0.4778, 0.3823, 0.3404, 0.2306, 0.1426, 0.4553, 0.2918, 0.4576], [1.0000, 0.1316, 0.0000, 0.0489, 0.0000, 0.0488, 0.0368, 0.1647, 0.0000], [1.0000, 0.3739, 0.3852, 0.3757, 0.3710, 0.3750, 0.3735, 0.3709, 0.3814], [1.0000, 0.1759, 0.2124, 0.2987, 0.2545, 0.2452, 0.2205, 0.2601, 0.1194], [1.0000, 0.5687, 0.4241, 0.4475, 0.5054, 0.3976, 0.6995, 0.5287, 0.6162], [1.0000, 0.4020, 0.3185, 0.3492, 0.3004, 0.3069, 0.3169, 0.4038, 0.2477], [1.0000, 0.7171, 0.7869, 0.7598, 0.5017, 0.5298, 0.6803, 0.5240, 0.8587], [1.0000, 0.0093, 0.0000, 0.0000, 0.0000, 0.0000, 0.0512, 0.0000, 0.0000], [1.0000, 0.1576, 0.1596, 0.1634, 0.1509, 0.1525, 0.1530, 0.1484, 0.1363], [1.0000, 0.2699, 0.2586, 0.2315, 0.2264, 0.2556, 0.3095, 0.2530, 0.2626], [1.0000, 0.4996, 0.7376, 0.5845, 0.5026, 0.5416, 0.7209, 0.6077, 0.8075], [1.0000, 0.2294, 0.2959, 0.1532, 0.2419, 0.1791, 0.4801, 0.2566, 0.3095], [1.0000, 0.4748, 0.4633, 0.3349, 0.2748, 0.0431, 0.5011, 0.3517, 0.4863], [1.0000, 0.2493, 0.1564, 0.0000, 0.0712, 0.1000, 0.1236, 0.3585, 0.0000], [1.0000, 0.4815, 0.5105, 0.5129, 0.5260, 0.4972, 0.5279, 0.5076, 0.5063], [1.0000, 0.0903, 0.1405, 0.0000, 0.0859, 0.0381, 0.1460, 0.1744, 0.1082], [1.0000, 0.6403, 0.6622, 0.6101, 0.5114, 0.5296, 0.6559, 0.7462, 0.7514], [1.0000, 0.4477, 0.4912, 0.1970, 0.3378, 0.2475, 0.4770, 0.5339, 0.2858], [1.0000, 0.7467, 0.8293, 0.7946, 0.6081, 0.0000, 0.7131, 0.3601, 0.9315], [1.0000, 0.0000, 0.2192, 0.0000, 0.0000, 0.0000, 0.0215, 0.3468, 0.0000], [1.0000, 0.5405, 0.5456, 0.5322, 0.5318, 0.5414, 0.5398, 0.5299, 0.5509], [1.0000, 0.1741, 0.1936, 0.1821, 0.1959, 0.1407, 0.2030, 0.1982, 0.1941], [1.0000, 0.4565, 0.8560, 0.6912, 0.6698, 0.4399, 0.7138, 0.6294, 0.8710], [1.0000, 0.1411, 0.3000, 0.1577, 0.3441, 0.1649, 0.3188, 0.2848, 0.2459], [1.0000, 0.1351, 0.3631, 0.0992, 0.1824, 0.0622, 0.4545, 0.4068, 0.3307], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.2201, 0.0000], [1.0000, 0.3300, 0.3134, 0.3246, 0.3012, 0.3051, 0.3310, 0.3336, 0.3033], [1.0000, 0.5172, 0.5370, 0.5384, 0.5630, 0.4564, 0.5672, 0.5845, 0.4645], [1.0000, 0.7822, 0.6858, 0.7619, 0.5703, 0.3384, 0.7089, 0.5903, 0.8990], [1.0000, 0.1887, 0.0429, 0.0000, 0.0849, 0.0000, 0.1481, 0.1314, 0.0000], [1.0000, 0.8627, 0.8877, 0.8333, 0.6054, 0.2037, 0.7198, 0.6106, 0.9487], [1.0000, 0.1551, 0.1198, 0.0000, 0.1528, 0.0000, 0.2112, 0.2552, 0.0000], [1.0000, 0.2194, 0.2058, 0.2167, 0.2271, 0.2125, 0.2321, 0.2143, 0.2293], [1.0000, 0.5898, 0.6117, 0.6155, 0.6387, 0.6107, 0.6453, 0.6245, 0.6200], [1.0000, 0.5574, 0.7433, 0.7011, 0.6945, 0.3841, 0.7638, 0.5970, 0.8653], [1.0000, 0.4726, 0.5112, 0.5446, 0.6475, 0.5031, 0.7195, 0.5784, 0.6321], [1.0000, 0.4353, 0.3214, 0.2566, 0.4924, 0.0094, 0.5173, 0.2852, 0.5335], [1.0000, 0.0000, 0.0000, 0.0000, 0.0752, 0.0000, 0.0000, 0.0690, 0.0000], [1.0000, 0.0141, 0.0413, 0.0256, 0.0295, 0.0286, 0.0427, 0.0065, 0.0296], [1.0000, 0.5484, 0.5855, 0.5617, 0.5588, 0.5062, 0.5674, 0.5484, 0.5362], [1.0000, 0.8801, 0.8004, 0.8198, 0.6082, 0.4334, 0.7248, 0.2413, 0.9006], [1.0000, 0.1481, 0.2045, 0.2169, 0.1066, 0.0356, 0.1981, 0.0842, 0.0729], [1.0000, 0.9532, 0.9407, 0.8279, 0.7639, 0.0870, 0.7448, 0.2465, 1.0000], [1.0000, 0.0445, 0.0000, 0.0000, 0.1106, 0.0000, 0.0522, 0.1220, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.7838, 0.7813, 0.7745, 0.7566, 0.7582, 0.7827, 0.7943, 0.7620], [1.0000, 0.8269, 0.8024, 0.7745, 0.6434, 0.2785, 0.7649, 0.7684, 0.9413], [1.0000, 0.6396, 0.5074, 0.6175, 0.6029, 0.4884, 0.7032, 0.6732, 0.6163], [1.0000, 0.6185, 0.5700, 0.4428, 0.4925, 0.0694, 0.5588, 0.2509, 0.6400], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1647, 0.1400, 0.1721, 0.1604, 0.1569, 0.1485, 0.1604, 0.1680], [1.0000, 0.2808, 0.2999, 0.3082, 0.2669, 0.3016, 0.2614, 0.2494, 0.2486], [1.0000, 0.8571, 0.8649, 0.7009, 0.7006, 0.2645, 0.7100, 0.3114, 0.8318], [1.0000, 0.0000, 0.0410, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.9117, 0.9525, 0.7546, 0.7820, 0.0871, 0.7762, 0.3529, 0.9404], [1.0000, 0.0654, 0.1407, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.3155, 0.3280, 0.3331, 0.3331, 0.3236, 0.3382, 0.3247, 0.3268], [1.0000, 0.6608, 0.6511, 0.6297, 0.6411, 0.6475, 0.6528, 0.6537, 0.6173], [1.0000, 0.8086, 0.8619, 0.6599, 0.6420, 0.3279, 0.7685, 0.5879, 0.8982], [1.0000, 0.5746, 0.5191, 0.4565, 0.5612, 0.5306, 0.6747, 0.5609, 0.5407], [1.0000, 0.7511, 0.5984, 0.4375, 0.5307, 0.0879, 0.5853, 0.2138, 0.5637], [1.0000, 0.1019, 0.0078, 0.0000, 0.1540, 0.0904, 0.0000, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0030], [1.0000, 0.6394, 0.6103, 0.5401, 0.5688, 0.5070, 0.5983, 0.4934, 0.5630], [1.0000, 0.9741, 0.9050, 0.7336, 0.7337, 0.0000, 0.7795, 0.1547, 0.8589], [1.0000, 0.6358, 0.3551, 0.2339, 0.1456, 0.0000, 0.3719, 0.0726, 0.3216], [1.0000, 1.0000, 1.0000, 0.8256, 0.8246, 0.0000, 0.8211, 0.2199, 0.9514], [1.0000, 0.3926, 0.2160, 0.1087, 0.1091, 0.0000, 0.2522, 0.0000, 0.2032], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.6134, 0.6424, 0.6532, 0.6246, 0.6316, 0.6415, 0.6075, 0.5831], [1.0000, 0.7810, 0.9542, 0.7043, 0.5464, 0.1442, 0.7872, 0.5508, 0.9295], [1.0000, 0.4504, 0.6340, 0.4256, 0.3665, 0.3814, 0.6379, 0.4677, 0.5067], [1.0000, 0.8272, 0.6898, 0.5129, 0.5284, 0.1350, 0.6630, 0.5605, 0.6396], [1.0000, 0.1169, 0.0616, 0.0242, 0.2358, 0.0838, 0.0434, 0.2525, 0.0484], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1705, 0.2378, 0.0948, 0.1835, 0.2570, 0.1931, 0.2451, 0.0963], [1.0000, 0.8390, 0.8611, 0.5535, 0.5788, 0.0000, 0.7664, 0.4611, 0.6121], [1.0000, 0.0000, 0.0406, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.9929, 0.9873, 0.7751, 0.7974, 0.0000, 0.8439, 0.5019, 0.9601], [1.0000, 0.0146, 0.0000, 0.0000, 0.0882, 0.1485, 0.0000, 0.1870, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.6774, 0.7297, 0.6808, 0.7229, 0.7258, 0.7573, 0.7789, 0.6963], [1.0000, 0.7773, 0.8741, 0.6528, 0.6711, 0.1787, 0.7886, 0.4975, 0.8315], [1.0000, 0.4911, 0.5091, 0.4323, 0.5993, 0.4558, 0.6987, 0.6196, 0.5641], [1.0000, 0.7375, 0.5612, 0.5826, 0.6670, 0.2974, 0.5782, 0.1464, 0.5704], [1.0000, 0.0000, 0.0000, 0.0000, 0.1742, 0.1042, 0.0000, 0.0000, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2132, 0.2093, 0.1231, 0.1700, 0.2937, 0.0701, 0.1695, 0.0393], [1.0000, 0.6479, 0.5265, 0.3637, 0.5499, 0.3564, 0.5783, 0.0544, 0.2846], [1.0000, 0.0842, 0.0000, 0.0000, 0.0000, 0.0323, 0.0000, 0.0000, 0.0000], [1.0000, 0.9767, 0.8897, 0.8486, 0.7274, 0.4749, 0.8000, 0.5431, 0.8936], [1.0000, 0.2837, 0.0000, 0.0633, 0.5684, 0.5087, 0.0000, 0.4860, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3286, 0.2556, 0.2767, 0.3716, 0.3447, 0.2982, 0.3847, 0.2178], [1.0000, 0.8969, 0.8345, 0.6897, 0.7239, 0.0599, 0.8371, 0.3316, 0.7848], [1.0000, 0.4415, 0.1762, 0.1462, 0.2692, 0.1784, 0.3735, 0.2071, 0.1722], [1.0000, 0.7729, 0.2008, 0.5299, 0.6563, 0.3593, 0.5283, 0.0000, 0.4717], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.3428, 0.2772, 0.3314, 0.3381, 0.3249, 0.3168, 0.3296, 0.3261], [1.0000, 0.0000, 0.0000, 0.0000, 0.3820, 0.5636, 0.0000, 0.0000, 0.0000], [1.0000, 0.6627, 0.4939, 0.4486, 0.6716, 0.0455, 0.6930, 0.2167, 0.5837], [1.0000, 0.0000, 0.0584, 0.0000, 0.4835, 0.5967, 0.0000, 0.0000, 0.0000], [1.0000, 1.0000, 0.7669, 0.8212, 0.8343, 0.3758, 0.8100, 0.7366, 1.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9952, 0.9912, 1.0000], [1.0000, 1.0000, 0.5603, 1.0000, 1.0000, 0.2655, 0.7721, 0.5165, 1.0000], [1.0000, 1.0000, 0.7800, 0.8378, 0.9056, 0.0000, 0.8240, 0.5657, 1.0000], [1.0000, 0.2878, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.2274, 0.3910, 0.0722, 0.0000, 0.1735], [1.0000, 0.0000, 0.0000, 0.0000, 0.0842, 0.4318, 0.0000, 0.0256, 0.0000], [1.0000, 1.0000, 0.5338, 0.7605, 0.5655, 0.5500, 0.6857, 0.6536, 0.8078], [1.0000, 0.0000, 0.0697, 0.0000, 0.0000, 0.0403, 0.0929, 0.0000, 0.0000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    elif method == 'lw_adamergingpp' and model == 'ViT-L-14':
        # Layer-wise AdaMerging++ ViT-L/14
        ralpha = [[1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.1738, 0.2772, 0.2947, 0.2655, 0.2531, 0.2378, 0.2631, 0.2397], [1.0000, 0.3955, 0.3150, 0.2859, 0.2983, 0.3473, 0.3583, 0.2715, 0.2225], [1.0000, 0.8463, 0.8420, 0.8181, 0.8236, 0.0000, 0.9469, 0.1904, 1.0000], [1.0000, 0.4265, 0.2279, 0.0872, 0.3156, 0.2022, 0.3329, 0.3187, 0.3496], [1.0000, 0.1653, 0.1644, 0.0643, 0.1695, 0.1265, 0.2099, 0.1506, 0.1762], [1.0000, 0.2929, 0.2586, 0.0000, 0.4237, 0.4511, 0.4154, 0.2709, 0.1874], [1.0000, 0.3535, 0.3565, 0.3789, 0.3770, 0.3978, 0.3844, 0.3724, 0.3605], [1.0000, 0.2332, 0.2526, 0.2772, 0.3105, 0.3030, 0.2687, 0.2532, 0.2561], [1.0000, 0.1120, 0.0000, 0.1682, 0.2784, 0.2976, 0.0260, 0.0825, 0.0869], [1.0000, 0.1496, 0.1880, 0.1528, 0.3347, 0.3542, 0.2149, 0.1942, 0.1535], [1.0000, 0.1838, 0.0400, 0.0324, 0.3356, 0.4342, 0.3063, 0.0494, 0.0594], [1.0000, 0.1876, 0.1380, 0.0000, 0.3207, 0.4558, 0.3502, 0.1781, 0.1033], [1.0000, 0.4841, 0.4777, 0.4889, 0.4482, 0.4919, 0.4835, 0.4866, 0.4882], [1.0000, 0.1124, 0.1585, 0.1306, 0.2118, 0.2028, 0.1121, 0.1421, 0.1902], [1.0000, 0.0899, 0.2903, 0.1390, 0.2707, 0.1815, 0.1937, 0.0486, 0.1942], [1.0000, 0.2465, 0.2764, 0.2184, 0.3043, 0.1914, 0.2492, 0.2296, 0.2720], [1.0000, 0.0000, 0.0153, 0.0000, 0.0000, 0.0314, 0.2445, 0.0000, 0.0000], [1.0000, 0.1250, 0.0131, 0.0000, 0.0948, 0.1861, 0.3366, 0.0535, 0.0000], [1.0000, 0.4763, 0.4306, 0.3458, 0.3891, 0.4370, 0.4443, 0.3878, 0.3813], [1.0000, 0.1597, 0.0644, 0.1797, 0.1610, 0.1622, 0.2318, 0.1713, 0.1152], [1.0000, 0.3434, 0.3580, 0.3388, 0.3508, 0.3383, 0.2306, 0.1403, 0.2931], [1.0000, 0.3216, 0.2973, 0.2841, 0.3329, 0.3225, 0.4017, 0.2870, 0.3198], [1.0000, 0.2090, 0.1601, 0.1510, 0.2043, 0.2379, 0.4266, 0.0527, 0.2142], [1.0000, 0.0000, 0.0334, 0.0000, 0.0593, 0.1735, 0.3196, 0.0790, 0.0000], [1.0000, 0.0339, 0.0886, 0.0854, 0.0000, 0.0443, 0.0702, 0.1276, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0730, 0.0793, 0.0000, 0.0351, 0.0000], [1.0000, 0.0911, 0.2238, 0.1357, 0.3700, 0.3800, 0.4232, 0.2568, 0.0297], [1.0000, 0.0000, 0.0414, 0.0000, 0.0603, 0.0765, 0.0251, 0.0000, 0.0000], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1057, 0.4219, 0.0000, 0.0000], [1.0000, 0.1926, 0.4111, 0.0000, 0.0000, 0.6076, 0.6148, 0.2722, 0.0425], [1.0000, 0.1942, 0.2447, 0.2712, 0.3018, 0.3979, 0.3766, 0.2948, 0.3144], [1.0000, 0.1823, 0.3430, 0.2647, 0.3031, 0.4256, 0.3999, 0.3114, 0.2046], [1.0000, 0.1695, 0.2493, 0.2158, 0.3172, 0.5719, 0.5670, 0.3823, 0.2429], [1.0000, 0.1071, 0.1385, 0.1299, 0.1489, 0.2817, 0.2204, 0.1853, 0.1033], [1.0000, 0.0714, 0.0827, 0.0551, 0.1633, 0.3846, 0.5723, 0.0417, 0.0657], [1.0000, 0.0000, 0.2281, 0.0122, 0.2897, 0.5412, 0.6102, 0.3393, 0.0000], [1.0000, 0.0106, 0.1020, 0.0000, 0.0799, 0.2014, 0.1433, 0.0887, 0.0759], [1.0000, 0.1691, 0.3777, 0.1764, 0.4338, 0.6115, 0.6099, 0.5628, 0.3904], [1.0000, 0.0700, 0.0238, 0.0240, 0.2097, 0.4117, 0.2032, 0.1503, 0.0266], [1.0000, 0.6323, 0.4960, 0.5174, 0.5937, 0.6577, 0.5454, 0.5771, 0.5985], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1330, 0.5269, 0.0000, 0.0000], [1.0000, 0.1817, 0.3539, 0.0000, 0.2121, 0.4367, 0.4818, 0.2608, 0.2345], [1.0000, 0.4275, 0.4240, 0.4304, 0.3996, 0.4049, 0.4460, 0.4130, 0.3831], [1.0000, 0.2852, 0.3349, 0.1866, 0.2037, 0.2477, 0.4729, 0.2531, 0.2042], [1.0000, 0.1762, 0.2449, 0.3833, 0.5665, 0.5005, 0.7681, 0.3509, 0.3001], [1.0000, 0.4155, 0.5051, 0.3647, 0.4186, 0.4426, 0.5213, 0.4053, 0.3736], [1.0000, 0.3845, 0.2751, 0.4426, 0.5493, 0.6164, 0.8122, 0.3111, 0.3236], [1.0000, 0.2555, 0.1573, 0.1031, 0.1107, 0.1491, 0.3608, 0.0673, 0.1623], [1.0000, 0.3958, 0.4412, 0.3192, 0.4217, 0.3819, 0.4436, 0.4059, 0.3867], [1.0000, 0.2972, 0.3443, 0.3697, 0.4155, 0.5301, 0.5630, 0.5566, 0.1844], [1.0000, 0.2963, 0.1364, 0.2083, 0.4704, 0.3796, 0.5743, 0.0025, 0.1065], [1.0000, 0.3820, 0.3723, 0.3957, 0.3987, 0.4189, 0.4423, 0.2956, 0.2948], [1.0000, 0.0685, 0.3050, 0.0000, 0.0538, 0.3066, 0.4489, 0.0000, 0.0000], [1.0000, 0.3082, 0.5765, 0.1277, 0.2973, 0.3419, 0.2991, 0.4278, 0.1649], [1.0000, 0.3356, 0.3393, 0.2804, 0.2611, 0.2920, 0.2614, 0.3492, 0.2476], [1.0000, 0.3738, 0.3673, 0.3604, 0.4484, 0.4170, 0.5165, 0.3471, 0.4913], [1.0000, 0.3552, 0.3504, 0.4385, 0.5241, 0.5373, 0.7296, 0.4793, 0.3762], [1.0000, 0.3609, 0.2612, 0.2793, 0.3077, 0.3684, 0.3954, 0.2719, 0.3902], [1.0000, 0.1697, 0.1656, 0.2222, 0.3649, 0.3540, 0.6343, 0.1490, 0.1892], [1.0000, 0.2029, 0.2952, 0.0190, 0.0947, 0.3512, 0.2769, 0.1277, 0.1608], [1.0000, 0.4176, 0.4456, 0.4037, 0.3947, 0.4301, 0.4332, 0.4190, 0.3832], [1.0000, 0.3011, 0.2574, 0.1477, 0.1404, 0.4035, 0.5075, 0.2678, 0.2376], [1.0000, 0.2711, 0.1682, 0.1710, 0.3489, 0.4417, 0.6936, 0.2578, 0.1258], [1.0000, 0.4390, 0.3103, 0.3695, 0.4188, 0.4077, 0.5119, 0.4069, 0.4783], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.2491, 0.4967, 0.0000, 0.0000], [1.0000, 0.3302, 0.2250, 0.0000, 0.2182, 0.3266, 0.3758, 0.1410, 0.1558], [1.0000, 0.0704, 0.0783, 0.0768, 0.0728, 0.1109, 0.0878, 0.0726, 0.0765], [1.0000, 0.4179, 0.4326, 0.4914, 0.3969, 0.4483, 0.4016, 0.3157, 0.4491], [1.0000, 0.0228, 0.1041, 0.1027, 0.4830, 0.4698, 0.6093, 0.2555, 0.1216], [1.0000, 0.3215, 0.2996, 0.2085, 0.3225, 0.4404, 0.3823, 0.3288, 0.2591], [1.0000, 0.1130, 0.0247, 0.0711, 0.3132, 0.4224, 0.7909, 0.2340, 0.3734], [1.0000, 0.2087, 0.2420, 0.0822, 0.3074, 0.3433, 0.3297, 0.1476, 0.1384], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4133, 0.3563, 0.3704, 0.3109, 0.4497, 0.4595, 0.1918, 0.4537], [1.0000, 0.0854, 0.0346, 0.0192, 0.0378, 0.2088, 0.3594, 0.0000, 0.2224], [1.0000, 0.4329, 0.4280, 0.4440, 0.3373, 0.3865, 0.3647, 0.2357, 0.6078], [1.0000, 0.1195, 0.1091, 0.0000, 0.0967, 0.4576, 0.6320, 0.0000, 0.1216], [1.0000, 0.3266, 0.3627, 0.0555, 0.5423, 0.4315, 0.3571, 0.0999, 0.2853], [1.0000, 0.3903, 0.4089, 0.4065, 0.4039, 0.4677, 0.4285, 0.4468, 0.3828], [1.0000, 0.3193, 0.0752, 0.0000, 0.0000, 0.1985, 0.1970, 0.0811, 0.2006], [1.0000, 0.2851, 0.1368, 0.0540, 0.1677, 0.4152, 0.6516, 0.1453, 0.2805], [1.0000, 0.3845, 0.3744, 0.2532, 0.2761, 0.4519, 0.4083, 0.3223, 0.3956], [1.0000, 0.3928, 0.1585, 0.2168, 0.2020, 0.4188, 0.7137, 0.0756, 0.2139], [1.0000, 0.2714, 0.2225, 0.0207, 0.2125, 0.3378, 0.3792, 0.0654, 0.1993], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2509, 0.1927, 0.0000, 0.0000, 0.0537, 0.2048, 0.0000, 0.0551], [1.0000, 0.1919, 0.3004, 0.0331, 0.0050, 0.3376, 0.7385, 0.0000, 0.3097], [1.0000, 0.5121, 0.3758, 0.3091, 0.0000, 0.2795, 0.5809, 0.0402, 0.4427], [1.0000, 0.0361, 0.0642, 0.0000, 0.0000, 0.3380, 0.7222, 0.0000, 0.1708], [1.0000, 0.0632, 0.0562, 0.0000, 0.0898, 0.1406, 0.3616, 0.0000, 0.0187], [1.0000, 0.0938, 0.0829, 0.0706, 0.0715, 0.0572, 0.0781, 0.0622, 0.0819], [1.0000, 0.4475, 0.4615, 0.3816, 0.3129, 0.3633, 0.4483, 0.2810, 0.4174], [1.0000, 0.2622, 0.2245, 0.0798, 0.0747, 0.2215, 0.5158, 0.0000, 0.2512], [1.0000, 0.3864, 0.3624, 0.2554, 0.2577, 0.2930, 0.3704, 0.2492, 0.2835], [1.0000, 0.2820, 0.2100, 0.1174, 0.3546, 0.4920, 0.7608, 0.0145, 0.1182], [1.0000, 0.2210, 0.0724, 0.0000, 0.1859, 0.3241, 0.3825, 0.0972, 0.3272], [1.0000, 0.0126, 0.0075, 0.0050, 0.0079, 0.0106, 0.0431, 0.0000, 0.0074], [1.0000, 0.2615, 0.0959, 0.0256, 0.0225, 0.1051, 0.2634, 0.1400, 0.0990], [1.0000, 0.0041, 0.1282, 0.0000, 0.0216, 0.3442, 0.7707, 0.0000, 0.0000], [1.0000, 0.1116, 0.4087, 0.0640, 0.0000, 0.2316, 0.5766, 0.0485, 0.0510], [1.0000, 0.0000, 0.0208, 0.0000, 0.0000, 0.4754, 0.6820, 0.0000, 0.0000], [1.0000, 0.3282, 0.5279, 0.0000, 0.0000, 0.7418, 0.5463, 0.0000, 0.6744], [1.0000, 0.2538, 0.2299, 0.2320, 0.2192, 0.2569, 0.2584, 0.2352, 0.2496], [1.0000, 0.3656, 0.2997, 0.2623, 0.2887, 0.3344, 0.3530, 0.3397, 0.2699], [1.0000, 0.3988, 0.2460, 0.1347, 0.3143, 0.4336, 0.7691, 0.2078, 0.3408], [1.0000, 0.0226, 0.1256, 0.1139, 0.0997, 0.0769, 0.1612, 0.0457, 0.0298], [1.0000, 0.4501, 0.2793, 0.1997, 0.4609, 0.5598, 0.8360, 0.2789, 0.1239], [1.0000, 0.0379, 0.0000, 0.0000, 0.0000, 0.0503, 0.1283, 0.0680, 0.0000], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2088, 0.1241, 0.0464, 0.1166, 0.1545, 0.1616, 0.0745, 0.1304], [1.0000, 0.0840, 0.1855, 0.0449, 0.3514, 0.4203, 0.7779, 0.0488, 0.2835], [1.0000, 0.0194, 0.1852, 0.0000, 0.0000, 0.1791, 0.4409, 0.0000, 0.1217], [1.0000, 0.1222, 0.0000, 0.0000, 0.1436, 0.3232, 0.6287, 0.0000, 0.0000], [1.0000, 0.0727, 0.0000, 0.0000, 0.3550, 0.3851, 0.4331, 0.1835, 0.4117], [1.0000, 0.3007, 0.3199, 0.2840, 0.2911, 0.3211, 0.3116, 0.3140, 0.3105], [1.0000, 0.3326, 0.3564, 0.1777, 0.2166, 0.2850, 0.2513, 0.1785, 0.2839], [1.0000, 0.5152, 0.2351, 0.1921, 0.4896, 0.5345, 0.7396, 0.2969, 0.3350], [1.0000, 0.3599, 0.3397, 0.2987, 0.3456, 0.3620, 0.3743, 0.2940, 0.3387], [1.0000, 0.3021, 0.1270, 0.2646, 0.5586, 0.6024, 0.8244, 0.4378, 0.2837], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0198, 0.0144, 0.0000, 0.0000], [1.0000, 0.4253, 0.4084, 0.4232, 0.4115, 0.4315, 0.4171, 0.4043, 0.3927], [1.0000, 0.2984, 0.0000, 0.0000, 0.0000, 0.0279, 0.0928, 0.0000, 0.0298], [1.0000, 0.3994, 0.1295, 0.1076, 0.4703, 0.5597, 0.8455, 0.2173, 0.1231], [1.0000, 0.4001, 0.2223, 0.0087, 0.2235, 0.1197, 0.5236, 0.0342, 0.0000], [1.0000, 0.0370, 0.0000, 0.0000, 0.1363, 0.3247, 0.7695, 0.0000, 0.0629], [1.0000, 1.0000, 0.6813, 0.0000, 0.4372, 0.5730, 0.8808, 0.3043, 0.7834], [1.0000, 0.0257, 0.0038, 0.0000, 0.0198, 0.0207, 0.0169, 0.0000, 0.0000], [1.0000, 0.6080, 0.5181, 0.4291, 0.4974, 0.4605, 0.6174, 0.3335, 0.5043], [1.0000, 0.3567, 0.3489, 0.2138, 0.4202, 0.5645, 0.8197, 0.3277, 0.4065], [1.0000, 0.0283, 0.0000, 0.0000, 0.0000, 0.1080, 0.0478, 0.0000, 0.0000], [1.0000, 0.2623, 0.2792, 0.4995, 0.5374, 0.5538, 0.8454, 0.5072, 0.3550], [1.0000, 0.3242, 0.3588, 0.0899, 0.2800, 0.4722, 0.2755, 0.1942, 0.1601], [1.0000, 0.0829, 0.0670, 0.0642, 0.0809, 0.0631, 0.0799, 0.0759, 0.0899], [1.0000, 0.4312, 0.3584, 0.2888, 0.3694, 0.2416, 0.3405, 0.2394, 0.3335], [1.0000, 0.4202, 0.5213, 0.3617, 0.5465, 0.5530, 0.8686, 0.3222, 0.6688], [1.0000, 0.2129, 0.5644, 0.3411, 0.3552, 0.2359, 0.7602, 0.2680, 0.4417], [1.0000, 0.3518, 0.0352, 0.1048, 0.2193, 0.2770, 0.7492, 0.0517, 0.1636], [1.0000, 0.9820, 0.8497, 0.6740, 0.4768, 0.5355, 0.6701, 0.3847, 0.4436], [1.0000, 0.1377, 0.1334, 0.1355, 0.1287, 0.1205, 0.1365, 0.1123, 0.1367], [1.0000, 0.4454, 0.4101, 0.3348, 0.2973, 0.2937, 0.4543, 0.2719, 0.3479], [1.0000, 0.3235, 0.4423, 0.4893, 0.5717, 0.6300, 0.7967, 0.3181, 0.4668], [1.0000, 0.1331, 0.1396, 0.1393, 0.1299, 0.1375, 0.2015, 0.1096, 0.1079], [1.0000, 0.2340, 0.5636, 0.4437, 0.5563, 0.6568, 0.8844, 0.4976, 0.3931], [1.0000, 0.1669, 0.2649, 0.3088, 0.2384, 0.1176, 0.4578, 0.1432, 0.2291], [1.0000, 0.1766, 0.1970, 0.1633, 0.1766, 0.1906, 0.2137, 0.1964, 0.1616], [1.0000, 0.3039, 0.2583, 0.2596, 0.2334, 0.2763, 0.3150, 0.2446, 0.2377], [1.0000, 0.2450, 0.5677, 0.2483, 0.3806, 0.5386, 0.8448, 0.3012, 0.3994], [1.0000, 0.2704, 0.3647, 0.1763, 0.1818, 0.2007, 0.6436, 0.0968, 0.2212], [1.0000, 0.3099, 0.1594, 0.0727, 0.0922, 0.3498, 0.7372, 0.0526, 0.4333], [1.0000, 0.6368, 0.5237, 0.2581, 0.1360, 0.3472, 0.4244, 0.0000, 0.6454], [1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0025, 0.0000, 0.0000], [1.0000, 0.1859, 0.1875, 0.1762, 0.1668, 0.2721, 0.2557, 0.2307, 0.2471], [1.0000, 0.5615, 0.5978, 0.4301, 0.5281, 0.6398, 0.8364, 0.4042, 0.5351], [1.0000, 0.5165, 0.5147, 0.5146, 0.5160, 0.4981, 0.5695, 0.5112, 0.5510], [1.0000, 0.5737, 0.6768, 0.4450, 0.5564, 0.6776, 0.9006, 0.6942, 0.7429], [1.0000, 0.1953, 0.1491, 0.2947, 0.1036, 0.0180, 0.4043, 0.0954, 0.3027], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.2382, 0.1770, 0.1465, 0.1323, 0.1400, 0.1649, 0.1307, 0.1889], [1.0000, 0.6121, 0.5644, 0.4280, 0.4514, 0.5054, 0.8394, 0.3691, 0.7061], [1.0000, 0.3583, 0.3019, 0.3240, 0.1475, 0.1947, 0.6644, 0.0567, 0.3605], [1.0000, 0.4134, 0.3878, 0.2136, 0.1133, 0.0468, 0.7330, 0.0035, 0.4564], [1.0000, 0.3446, 0.3088, 0.2062, 0.0000, 0.0025, 0.5785, 0.0000, 0.5503], [1.0000, 0.5552, 0.5611, 0.5306, 0.5535, 0.5854, 0.5667, 0.5487, 0.5500], [1.0000, 0.7042, 0.4816, 0.4485, 0.3264, 0.3189, 0.5961, 0.3352, 0.3605], [1.0000, 0.4625, 0.6381, 0.4103, 0.4563, 0.7107, 0.7882, 0.6806, 0.6211], [1.0000, 0.1047, 0.1762, 0.1119, 0.1187, 0.2756, 0.3115, 0.2379, 0.0969], [1.0000, 0.5229, 0.7785, 0.5884, 0.6020, 0.5576, 0.8947, 0.6348, 0.8062], [1.0000, 0.0781, 0.0869, 0.1694, 0.0217, 0.0860, 0.4553, 0.1204, 0.2880], [1.0000, 0.0813, 0.0781, 0.0767, 0.0725, 0.0670, 0.0884, 0.0739, 0.0911], [1.0000, 0.3492, 0.2725, 0.2857, 0.2400, 0.3113, 0.3782, 0.2721, 0.3620], [1.0000, 0.7172, 0.9350, 0.6681, 0.5406, 0.5870, 0.8757, 0.5144, 0.9362], [1.0000, 0.3800, 0.4498, 0.4133, 0.2202, 0.2459, 0.6725, 0.2123, 0.5475], [1.0000, 0.3116, 0.4699, 0.3911, 0.3912, 0.4083, 0.7910, 0.1852, 0.6965], [1.0000, 0.4941, 0.5893, 0.6116, 0.5483, 0.6241, 0.6214, 0.2880, 0.4210], [1.0000, 0.8360, 0.7856, 0.7895, 0.7681, 0.8073, 0.8180, 0.7778, 0.7782], [1.0000, 0.5273, 0.4650, 0.3315, 0.2941, 0.4199, 0.4699, 0.2706, 0.3467], [1.0000, 0.6987, 0.9495, 0.5759, 0.6171, 0.6846, 0.9014, 0.5195, 0.7755], [1.0000, 0.1055, 0.1295, 0.0500, 0.0939, 0.1215, 0.1276, 0.0704, 0.1260], [1.0000, 0.8093, 1.0000, 0.7287, 0.7060, 0.6502, 0.9125, 0.5874, 0.9262], [1.0000, 0.0260, 0.0866, 0.0601, 0.0528, 0.1179, 0.2628, 0.0000, 0.2073], [1.0000, 0.2184, 0.2107, 0.2041, 0.2108, 0.1978, 0.2444, 0.2115, 0.2315], [1.0000, 0.3147, 0.2898, 0.3093, 0.3375, 0.3362, 0.3622, 0.3066, 0.3306], [1.0000, 0.7649, 1.0000, 0.7241, 0.6922, 0.5832, 0.8670, 0.5881, 0.8767], [1.0000, 0.5040, 0.4356, 0.4894, 0.5242, 0.3768, 0.6340, 0.3111, 0.4012], [1.0000, 0.7420, 0.7100, 0.5535, 0.4878, 0.3515, 0.7855, 0.2047, 0.6978], [1.0000, 0.6128, 0.6004, 0.5053, 0.5271, 0.5782, 0.7115, 0.2971, 0.4938], [1.0000, 0.1726, 0.2062, 0.1911, 0.1911, 0.2050, 0.1983, 0.1929, 0.2032], [1.0000, 0.3132, 0.3199, 0.3198, 0.3970, 0.2908, 0.3416, 0.3295, 0.2715], [1.0000, 0.7824, 0.7519, 0.6101, 0.6341, 0.5589, 0.8860, 0.6099, 0.7925], [1.0000, 0.4482, 0.4061, 0.3806, 0.3982, 0.3311, 0.4164, 0.3995, 0.3855], [1.0000, 0.8584, 0.9820, 0.7946, 0.7021, 0.6273, 0.8642, 0.5459, 0.9822], [1.0000, 0.0352, 0.0375, 0.0000, 0.1015, 0.1056, 0.3642, 0.0000, 0.2598], [1.0000, 0.1352, 0.1452, 0.1457, 0.1396, 0.1364, 0.1464, 0.1226, 0.1238], [1.0000, 0.2938, 0.2814, 0.2793, 0.2819, 0.3049, 0.3673, 0.2912, 0.2937], [1.0000, 0.6772, 1.0000, 0.7174, 0.6767, 0.6269, 0.8863, 0.6604, 0.8988], [1.0000, 0.1447, 0.2935, 0.2620, 0.3975, 0.2188, 0.7232, 0.3203, 0.3790], [1.0000, 0.7805, 0.7122, 0.5600, 0.5591, 0.3076, 0.8218, 0.3343, 0.7161], [1.0000, 0.6474, 0.6508, 0.3686, 0.5258, 0.5357, 0.7032, 0.4742, 0.6800], [1.0000, 0.3583, 0.3789, 0.3752, 0.3937, 0.3704, 0.3974, 0.3856, 0.3686], [1.0000, 0.2557, 0.1906, 0.2419, 0.2261, 0.1889, 0.3335, 0.2366, 0.3202], [1.0000, 0.7382, 0.9150, 0.7518, 0.6862, 0.6575, 0.8618, 0.7398, 0.8918], [1.0000, 0.3803, 0.3527, 0.3438, 0.3287, 0.3446, 0.4190, 0.3623, 0.3823], [1.0000, 0.8564, 0.9756, 0.7926, 0.7483, 0.5053, 0.9094, 0.3567, 1.0000], [1.0000, 0.1681, 0.1781, 0.0000, 0.0000, 0.0310, 0.2689, 0.0000, 0.2073], [1.0000, 0.5305, 0.5363, 0.5300, 0.5367, 0.5378, 0.5475, 0.5245, 0.5433], [1.0000, 0.2900, 0.2998, 0.2848, 0.2819, 0.2481, 0.3250, 0.2707, 0.2865], [1.0000, 0.6932, 1.0000, 0.8162, 0.8752, 0.6972, 0.8990, 0.7007, 1.0000], [1.0000, 0.2309, 0.3811, 0.2324, 0.3727, 0.3269, 0.5688, 0.3158, 0.3713], [1.0000, 0.5079, 0.7303, 0.4373, 0.3901, 0.1212, 0.7886, 0.3882, 0.6652], [1.0000, 0.5154, 0.5969, 0.4583, 0.3798, 0.4568, 0.5544, 0.7126, 0.4385], [1.0000, 0.3934, 0.3461, 0.3513, 0.3331, 0.3404, 0.3674, 0.3764, 0.3682], [1.0000, 0.4261, 0.4653, 0.4284, 0.4681, 0.3350, 0.5394, 0.4684, 0.5016], [1.0000, 0.9357, 0.9254, 0.8178, 0.7251, 0.6071, 0.9468, 0.7520, 1.0000], [1.0000, 0.1599, 0.0677, 0.1074, 0.0903, 0.0669, 0.2150, 0.0966, 0.0689], [1.0000, 1.0000, 1.0000, 0.9086, 0.7806, 0.4536, 0.9373, 0.7209, 1.0000], [1.0000, 0.4261, 0.4706, 0.2442, 0.1507, 0.1779, 0.4995, 0.0549, 0.1767], [1.0000, 0.2881, 0.2626, 0.2775, 0.2816, 0.2692, 0.3007, 0.2747, 0.2934], [1.0000, 0.4377, 0.4390, 0.4272, 0.4528, 0.4509, 0.4946, 0.4562, 0.4687], [1.0000, 0.7391, 0.9881, 0.7803, 0.7787, 0.3829, 0.9046, 0.6275, 0.9504], [1.0000, 0.3137, 0.4029, 0.4516, 0.4247, 0.1807, 0.7031, 0.3798, 0.4666], [1.0000, 0.7344, 0.7570, 0.6360, 0.6511, 0.2062, 0.8105, 0.4898, 0.8025], [1.0000, 0.5118, 0.5559, 0.3505, 0.4114, 0.5208, 0.4956, 0.4914, 0.2844], [1.0000, 0.1597, 0.1621, 0.1351, 0.1282, 0.1606, 0.1472, 0.1161, 0.1321], [1.0000, 0.3196, 0.3541, 0.3558, 0.3216, 0.2054, 0.4099, 0.2683, 0.3060], [1.0000, 1.0000, 1.0000, 0.8819, 0.8144, 0.7569, 0.9290, 0.6735, 1.0000], [1.0000, 0.4561, 0.4354, 0.4948, 0.4069, 0.3801, 0.4833, 0.3367, 0.4759], [1.0000, 1.0000, 1.0000, 0.9156, 0.9293, 0.5435, 0.9434, 0.6556, 1.0000], [1.0000, 0.3143, 0.3494, 0.4612, 0.1525, 0.0000, 0.6114, 0.1374, 0.2102], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.5528, 0.5594, 0.5508, 0.5450, 0.5300, 0.5817, 0.5607, 0.5591], [1.0000, 1.0000, 1.0000, 0.9419, 0.9238, 0.5928, 0.9279, 0.8700, 1.0000], [1.0000, 0.4377, 0.3308, 0.5983, 0.5376, 0.3167, 0.7401, 0.5311, 0.5699], [1.0000, 0.8224, 0.7985, 0.7099, 0.7076, 0.2700, 0.8323, 0.4304, 0.8305], [1.0000, 0.2717, 0.3529, 0.3191, 0.4256, 0.4354, 0.4074, 0.3860, 0.2600], [1.0000, 0.3667, 0.3507, 0.3614, 0.3797, 0.3794, 0.4030, 0.3837, 0.3607], [1.0000, 0.0000, 0.0143, 0.0192, 0.0000, 0.0000, 0.0170, 0.0000, 0.0317], [1.0000, 1.0000, 1.0000, 0.8862, 0.8641, 0.5693, 0.8991, 0.6755, 0.9792], [1.0000, 0.1331, 0.1599, 0.1068, 0.1199, 0.1198, 0.2043, 0.1172, 0.1650], [1.0000, 1.0000, 1.0000, 0.9065, 0.9044, 0.4803, 0.9514, 0.6197, 1.0000], [1.0000, 0.1996, 0.2061, 0.2108, 0.2977, 0.0000, 0.2589, 0.2265, 0.0561], [1.0000, 0.4420, 0.4453, 0.4543, 0.4563, 0.4507, 0.4620, 0.4535, 0.4515], [1.0000, 0.2302, 0.2334, 0.2256, 0.2126, 0.2177, 0.2400, 0.2162, 0.2060], [1.0000, 0.9771, 1.0000, 0.9091, 0.8409, 0.5196, 0.9314, 0.7406, 0.9941], [1.0000, 0.2113, 0.2205, 0.2320, 0.3246, 0.1526, 0.6068, 0.2687, 0.2324], [1.0000, 0.8462, 0.8011, 0.7121, 0.7370, 0.2056, 0.8473, 0.4437, 0.7532], [1.0000, 0.4040, 0.3401, 0.2479, 0.5042, 0.4354, 0.3586, 0.3869, 0.1430], [1.0000, 0.2138, 0.2477, 0.2128, 0.2131, 0.2257, 0.2523, 0.2288, 0.2252], [1.0000, 0.3472, 0.3336, 0.2554, 0.3001, 0.2162, 0.3481, 0.2469, 0.2948], [1.0000, 1.0000, 1.0000, 0.8644, 0.8853, 0.4460, 0.9445, 0.5706, 1.0000], [1.0000, 0.5464, 0.5125, 0.4363, 0.4095, 0.3977, 0.5091, 0.3271, 0.3602], [1.0000, 1.0000, 1.0000, 0.9516, 0.9492, 0.4676, 0.9739, 0.6060, 1.0000], [1.0000, 0.2818, 0.0658, 0.1390, 0.1468, 0.0000, 0.3400, 0.0000, 0.2721], [1.0000, 0.1221, 0.1164, 0.1208, 0.1145, 0.1184, 0.1281, 0.1155, 0.1220], [1.0000, 0.3083, 0.3538, 0.3407, 0.3157, 0.2914, 0.3309, 0.2915, 0.2875], [1.0000, 0.8683, 1.0000, 0.8028, 0.8438, 0.3032, 0.9409, 0.7760, 1.0000], [1.0000, 0.2006, 0.4002, 0.1501, 0.2296, 0.0633, 0.5556, 0.3043, 0.4335], [1.0000, 0.9257, 0.8667, 0.7636, 0.7902, 0.3468, 0.8945, 0.7117, 0.8360], [1.0000, 0.2952, 0.1976, 0.2846, 0.0498, 0.0995, 0.4149, 0.5821, 0.2490], [1.0000, 0.0969, 0.0757, 0.0378, 0.0608, 0.0631, 0.0783, 0.0629, 0.0374], [1.0000, 0.0495, 0.0887, 0.0357, 0.0437, 0.0944, 0.0592, 0.0805, 0.0269], [1.0000, 0.9801, 0.9805, 0.7240, 0.7351, 0.3356, 0.9301, 0.5685, 0.8084], [1.0000, 0.1557, 0.2023, 0.0626, 0.0000, 0.0000, 0.1318, 0.0000, 0.1002], [1.0000, 1.0000, 1.0000, 0.9535, 0.9647, 0.5232, 1.0000, 0.7546, 1.0000], [1.0000, 0.3807, 0.0000, 0.0705, 0.1420, 0.0000, 0.1109, 0.1453, 0.1117], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.4058, 0.4323, 0.4116, 0.4397, 0.4390, 0.4884, 0.4618, 0.4165], [1.0000, 0.8887, 1.0000, 0.8375, 0.9167, 0.5991, 0.9699, 0.6700, 0.9917], [1.0000, 0.3405, 0.3575, 0.3909, 0.4556, 0.3532, 0.7264, 0.3787, 0.4081], [1.0000, 0.7672, 0.7167, 0.7268, 0.8755, 0.5565, 0.8346, 0.5284, 0.7716], [1.0000, 0.0000, 0.0358, 0.0712, 0.1065, 0.0000, 0.0000, 0.0000, 0.0189], [1.0000, 0.1490, 0.0868, 0.1864, 0.1027, 0.0841, 0.1448, 0.0340, 0.0000], [1.0000, 0.2082, 0.1404, 0.0805, 0.0883, 0.1635, 0.0838, 0.1107, 0.0764], [1.0000, 0.7060, 0.6316, 0.4773, 0.7359, 0.3072, 0.7633, 0.3226, 0.4545], [1.0000, 0.2859, 0.0000, 0.1126, 0.0217, 0.0015, 0.0884, 0.0062, 0.0000], [1.0000, 1.0000, 1.0000, 0.9673, 0.9302, 0.6646, 0.9935, 0.7119, 1.0000], [1.0000, 0.4032, 0.0422, 0.4198, 0.6573, 0.5608, 0.4344, 0.6427, 0.2457], [1.0000, 0.1393, 0.1090, 0.1043, 0.1102, 0.1091, 0.1218, 0.1077, 0.1018], [1.0000, 0.1193, 0.0693, 0.1020, 0.1323, 0.1231, 0.0995, 0.1442, 0.0565], [1.0000, 0.9278, 0.9757, 0.8322, 0.9187, 0.3325, 0.9926, 0.5748, 0.9084], [1.0000, 0.2508, 0.1681, 0.0590, 0.1148, 0.0000, 0.3956, 0.0593, 0.2314], [1.0000, 0.7630, 0.4873, 0.6813, 0.8126, 0.3289, 0.7774, 0.3790, 0.6894], [1., 0., 0., 0., 0., 0., 0., 0., 0.], [1.0000, 0.1640, 0.1046, 0.1486, 0.1546, 0.1371, 0.1308, 0.1402, 0.1459], [1.0000, 0.0000, 0.0000, 0.0000, 0.2251, 0.2446, 0.0000, 0.0000, 0.0453], [1.0000, 0.5943, 0.5161, 0.5033, 0.8104, 0.1991, 0.8103, 0.2881, 0.6396], [1.0000, 0.2503, 0.1699, 0.2747, 0.3350, 0.1911, 0.2258, 0.1092, 0.1894], [1.0000, 1.0000, 1.0000, 1.0000, 0.9442, 0.2686, 0.9713, 0.5600, 1.0000], [1.0000, 0.0968, 0.0000, 0.0973, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 0.9950, 1.0000], [1.0000, 1.0000, 0.6120, 1.0000, 0.6650, 0.2977, 0.5775, 0.2725, 0.8972], [1.0000, 1.0000, 0.7865, 0.8627, 1.0000, 0.3570, 1.0000, 0.7535, 1.0000], [1.0000, 0.2479, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000], [1.0000, 0.1712, 0.0842, 0.2238, 0.7119, 0.1382, 0.3856, 0.0036, 0.3651], [1.0000e+00, 0.0000e+00, 1.0198e-04, 8.4671e-02, 3.7669e-01, 1.7429e-01, 2.6700e-01, 1.9150e-01, 1.7898e-01], [1.0000, 0.8136, 0.4394, 0.6225, 0.5260, 0.4065, 0.5970, 0.4864, 0.6803], [1.0000, 0.0900, 0.1684, 0.0566, 0.1364, 0.1086, 0.1674, 0.0474, 0.0802], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000], [1.0000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000, 0.3000]]

    else:
        print('Not defined.')

    print('load weight: ' + str(ralpha))

    return ralpha
