# SpecEdge

## Benchmark

### Install Dependencies

```bash
# Install dependencies via uv (recommended)
uv sync

# install dependencies via pip
pip install .
```

### SpecEdge

```bash
# run server
./script/batch_server.sh -f config/specedge.example.yaml

# run client
./script/client_host.sh -f config/specedge.example.yaml
```

### Server only

```bash
./script/server_only.sh -f config/server_only.example.yaml
```

### Autoregressive

```bash
./script/auto_batch.sh -f config/auto_batch.example.yaml
```

## Metrics

```bash
. .venv/bin/activate

# SpecEdge metrics
python src/metric/specedge.py -d result/demo/specedge

# Server only metrics
python src/metric/server_only.py -d result/demo/server_only

# Autoregressive metrics
python src/metric/auto_batch.py -d result/demo/auto_batch
```
