# VQ-T2G

Code for "Text-Conditioned Graph Generation Using Discrete Graph Variational Autoencoders"



## Installation

Install the relevant pytorch-geometric for your system. For example for torch geometric built for pytorch 1.12.1 and CUDA version 11.3:

  ```pip install torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric -f https://data.pyg.org/whl/torch-1.12.1+cu113.html```

See pyg docs for installation: https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html


Install remaining requirements with:
  ```pip install -r requirements.txt```





## Building datasets

### Synthetic dataset

To build the synthetic dataset run: 
  ```python build_datasets_main.py build-synthetic-dataset```

Default values are set such that this command builds it as specified in the paper. Dataset may be customised, add `--help` to the end to see available options.

### Two-community dataset

To build the two-community dataset run: 
  ```python build_datasets_main.py build-two-community-dataset```



## Training a new model

- The paper results may be reproduced by running the model with the respective config file using the process below
- The synthetic dataset may be generated without providing any additional arguments to the relevant function. All parameter defaults are set to the values used to generate the synthetic dataset used in the paper.



### Train GVQVAE

The first part is training the GVQVAE. For example to train the synthetic dataset run:

  ```python vqt2g_main.py gvqvae-train config/synthetic_config.yaml```



### Train transformer

After training the GVQVAE the transformer may be trained. A config file is the first argument, but must be the config file inside the GVQVAE experiment folder (as it automatically sets the path to the checkpoint, etc)

   ```python vqt2g_main.py transformer-train runs/example_run/config.yaml```


### Run evaluation

Perform evaluation of a trained model by running:
    ```python vqt2g_main.py run-vqt2g-evaluation runs/example_run/config.yaml```


