"""Graph class descriptions"""

import random


_barbell_class_descs = (
    "a {} barbell graph",
    "a network that looks like a {} barbell",
    "a synthetic barbell graph that is {}",
    "one graph, {}, shaped like a barbell",
    "one barbell graph, {}, synthetic",
    "a barbell-shaped graph, {}",
)

_lollipop_class_descs = (
    "a {} lollipop graph",
    "one {} lollipop network",
    "a synthetic lollipop graph that is {}",
    "one {} synthetic graph shaped like a lollipop",
    "one lollipop graph, {}, synthetic",
    "a lollipop shaped graph, and it's {}",
)

_clique_ring_class_descs = (
    "a {} ring of cliques graph",
    "a {} clique ring network",
    "one ring of cliques graph that is {}",
    "a synthetic graph, {}, of cliques in a ring",
    "one clique ring graph, and it's {}",
    "one {} ring of cliques",
    "a {} synthetic ring of cliques",
    "a clique ring graph that's {}",
    "one {} ring-of-cliques model graph",
    "a graph from the ring-of-cliques model that's {}",
)

_2d_grid_class_descs = (
    "a {} square lattice graph",
    "one {} square lattice",
    "a {} 2d grid graph",
    "a square lattice graph that's {}",
    "one 2d grid, {}",
    "a 2d grid graph, and it's {}",
    "one {} graph of squares graph",
    "one regular 2d graph, {}",
    "one {} 2d lattice graph",
)

_tri_grid_class_descs = (
    "a {} triangular lattice graph",
    "a {} graph of triangles in a grid",
    "one {} triangular grid",
    "a trianglular lattice that is {}",
    "one {} graph that is shaped as a triangular grid",
    "a regular triangular grid, and it's {}",
    "one {} lattice of triangles",
    "one regular {} triangular lattice",
)

_hex_grid_class_descs = (
    "a {} hexagonal lattice graph",
    "a {} graph of hexagons in a grid",
    "one {} hexagonal grid",
    "a hexagonal lattice that is {}",
    "one {} graph that is shaped as a hexagonal grid",
    "a regular hexagonal grid, and it's {}",
    "one {} lattice of hexagons",
    "one regular {} hexagonal lattice",
)

_watts_class_descs = (
    "a {} watts-strogatz random graph",
    "a synthetic {} watts strogatz network",
    "one circular {} watts-strogatz graph",
    "a network that is {}, generated from the watts strogatz model",
    "one synthetic watts strogatz graph, {}",
    "a circular-shaped, {}, synthetic watts-strogatz model network",
    "one watts-strogatz graph that's circular and {}",
    "one {} random graph that's from the watts strogatz model",
    "a {} graph from the watts-strogatz random graph model",
)

_star_class_descs = (
    "a {} star graph",
    "one star graph that is {}",
    "one {} tree shaped as a star",
    "a star graph that's {}",
    "a star-shaped graph, {}",
)

_path_class_descs = (
    "a {} path graph",
    "one path that is {}",
    "a synthetic, {}, graph shaped in a line",
    "one synthetic line graph that's {}",
    "a {} straight line graph",
)


_binary_tree_class_descs = (
    "a {} binary tree graph",
    "a full, {} binary tree",
    "one binary tree that is {}",
    "one synthetic binary tree, {}",
    "a {} tree where every node has exactly two children",
    "one tree graph that's {}, nodes have exactly two children",
    "a full binary tree that is {}",
    "a full r-ary tree, {}, where r is two",
    "a {} full r-ary tree with r equal to two",
    "a {} rooted tree, all nodes having two children",
)

_ternary_tree_class_descs = (
    "a {} ternary tree graph",
    "a full, {} ternary tree",
    "one ternary tree that is {}",
    "one synthetic ternary tree, {}",
    "a {} tree where every node has exactly three children",
    "one tree graph that's {}, nodes have exactly three children",
    "a full ternary tree that is {}",
    "a full r-ary tree, {}, where r is three",
    "a {} full r-ary tree with r equal to three",
    "a {} rooted tree, all nodes having three children",
)


_starlike_class_descs = (
    "a {} starlike tree graph",
    "a perfect, {}, starlike tree",
    "one starlike tree that is {}",
    "one starlike graph, {}, with long spokes",
    "one {} starlike tree that's synthetic",
    "a synthetic starlike graph that's {} and has long spokes",
    "a {} star graph with long spokes",
    "one {} star-like tree graph",
)


_banana_tree_class_descs = (
    "a {} banana tree graph",
    "one synthetic {} banana tree",
)


_firecracker_class_descs = (
    "a {} firecracker graph",
    "one firecracker graph that is {}",
)


_sunlet_class_descs = (
    "a {} sunlet graph",
    "one sunlet graph that is{}",
)


_helm_class_descs = (
    "a {} helm graph",
    "one helm graph that is {}",
)


_fan_class_descs = (
    "a {} fan graph",
    "one {} fan graph",
)


# Dict for graph class name with the corresponding list of class descriptions

_class_desc_map = {
    "barbell": _barbell_class_descs,
    "lollipop": _lollipop_class_descs,
    "clique_ring": _clique_ring_class_descs,
    "2d_grid": _2d_grid_class_descs,
    "tri_grid": _tri_grid_class_descs,
    "hex_grid": _hex_grid_class_descs,
    "watts": _watts_class_descs,
    "star": _star_class_descs,
    "path": _path_class_descs,
    "binary": _binary_tree_class_descs,
    "ternary": _ternary_tree_class_descs,
    "starlike": _starlike_class_descs,
    "banana_tree": _banana_tree_class_descs,
    "firecracker": _firecracker_class_descs,
    "sunlet": _sunlet_class_descs,
    "helm": _helm_class_descs,
    "fan": _fan_class_descs,
}


def get_class_description(graph_class):
    """Get a randomly chosen text that describes the graph class"""

    possible_texts = _class_desc_map.get(graph_class)
    if not possible_texts:
        raise ValueError(f"Invalid graph class for class description: {graph_class}")

    return random.choice(possible_texts)
