d = 50; % dimension of the data

M = 20;  % degree of the graph

N = 2 * 80;  % total number of training samples

% r = 10; % sampling ratio

N_p = N / 2; % number of positive data

N_g = N / 2; % number of negative data

K = 100; % 2*K = number of neurons

N_test = 20000; % number of test data

L = 50; % number of discriminative and non-discriminative patterns

T = 500; % number of maximum iterations

mag = 0.5; % magnitude of each pattern

sigma = 0.2; % noise level

O = generate_O( d , L, mag, sigma );

[ X, Y , ~ ] = generate_GX( N , O , M ); % generate the input vector

% X_s = sample_MR( X , M, r );

W = 1 / 10 * randn( d , K ); % initilize W

V = 1 / 10 * randn( d , K ); % initilize W

eta = 1 * K; % stepsize

training_error = nan( T , 1 ); % record of training error

fprintf( 'Loop Number =        ' );

for t = 1 : T
   
    fprintf('\b\b\b\b\b\b\b%6d\n', t);
    
    [ g_W , g_V ] = Gradient_GNN( W , V , X , Y);
    
    W = W - eta * g_W;

    V = V - eta * g_V;
    
    error_t =  mean( max( 1 -  generate_y( W , V , X).* Y , 0) ); 
    
    training_error( t , 1 ) = error_t;
        
    if error_t == 0 || ( norm( g_W , 'fro' ) == 0 && norm( g_V , 'fro' ) == 0 )
        
        break;
        
    end

end

plot( 1 : T , training_error );

xlabel('Number of iterations');

ylabel('Training loss');

[ X_test , Y_test ] = generate_GX( N , O , M );

Y_est = generate_y( W , V , X_test );

test_error = mean(  sign(Y_est) ~= sign( Y_test ) );
 
fprintf('test error = %f, test number = %d/%d\n' , test_error, sum( Y_est .* Y_test < 0 ), N_test * 2 );





