function [g_W , g_V ] = Gradient_GNN(W , V , X, Y )

[ ~, X_W, X_V ] = GNN(W ,V , X);

[ d , K] = size( W );

g_W = nan(d, K);

g_V = nan(d, K);

for k = 1: K
    
    w = W( : , k );
    
    v = V( : , k );
    
    X_w = X_W(:,:,k);
    
    X_v = X_V(:,:,k);
    
    I_w = repmat(  Y .*(w' * X_w > 0) , d, 1) .* X_w;
    
    I_v = repmat(  Y .*(v' * X_v > 0) , d, 1) .* X_v;
    
    g_W(:, k) = - 1/K * mean(I_w, 2);
    
    g_V(:, k) = 1/K * mean(I_v, 2);
    
end

end


