function [ y_est, X_W, X_V ] = GNN( W , V , X)

[ d , K ] = size( W );

[ p , N ] = size( X );

M = p / d;

X_W = nan( d , N , K );

X_V = nan( d , N , K );

O = dig_nan( ones(d,1) , M )';
   
for k = 1 : K
    
    w = W( : , k);
    
    v = V( : , k);
   
    w_r = dig( w , M );
    
    v_r = dig( v , M );
   
    [ ~ , I_w ] = max( w_r * X );
    
    O_w = O( :, I_w );
    
    X_s = X;
    
    X( isnan(O_w)) = [];
    
    X_W( : , : , k ) = reshape( X , d, N );
    
    X = X_s;
   
    [ ~ , I_v ] = max( v_r * X );
   
    O = dig_nan( ones(d,1) , M )';
    
    O_v = O( :, I_v );
    
    X_s = X;
    
    X( isnan(O_v) ) = [];
    
    X_V( : , : , k ) = reshape( X , d, N );
    
    X = X_s;
    
end

y_est = zeros( 1 , N );

for k = 1 : K
    
    X_w = X_W( : , : , k );
    
    X_v = X_V( : , : , k );
    
    y_est = y_est + 1/K * max( W(:,k)' * X_w , 0 ) - 1/K * max( V(:,k)' * X_v , 0 ) ;
    
end

end

function [ w_k ] = dig( w , M )

d = length( w );

w_k = nan( M , d*M );

o_1 = [ w' , zeros( 1 , d * ( M - 1 ) ) ];

for i = 1 : M
    
    w_k( i , : ) = o_1;
    
    o_1 = circshift( o_1 , d );
    
end

end

function [ w_k ] = dig_nan( w , M )

d = length( w );

w_k = nan( M , d*M );

o_1 = [ w' , nan( 1 , d * ( M - 1 ) ) ];

for i = 1 : M
    
    w_k( i , : ) = o_1;
    
    o_1 = circshift( o_1 , d );
    
end

end

