from evaluation.features.cub.load import get_cub_ft_evaluator
from evaluation.features.flowers.load import get_flowers_ft_evaluator
from evaluation.images.cub.load import get_cub_evaluator
from evaluation.images.flowers.load import get_flowers_evaluator
from evaluation.synthetic.load import get_synthetic_evaluator


def get_evaluator(dataset_name, method_name):
    if 'synth' in dataset_name:
        evaluator = get_synthetic_evaluator(method_name)
    elif dataset_name == 'cub_ft':
        evaluator = get_cub_ft_evaluator(method_name)
    elif dataset_name == 'flowers':
        evaluator = get_flowers_evaluator(method_name)
    elif dataset_name == 'flowers_ft':
        evaluator = get_flowers_ft_evaluator(method_name)
    elif dataset_name == 'cub':
        evaluator = get_cub_evaluator(method_name)
    else:
        raise ValueError('Please provide correct dataset name.')

    return evaluator
