import inspect
import os
from types import SimpleNamespace

import yaml

current_dir = os.path.dirname(
    os.path.abspath(inspect.getfile(inspect.currentframe())))


def get_args(dset_name, model):
    dir_ = os.path.join(current_dir, dset_name, f'{model}.yaml')
    with open(dir_, 'r') as stream:
        args = yaml.safe_load(stream)
    args = SimpleNamespace(**args)
    args.dset_name = dset_name
    args.model = model
    return args


def get_config():
    # load generic config
    with open(os.path.join(current_dir, 'config_general.yaml'), 'r') as stream:
        config = yaml.safe_load(stream)
    # load directory file
    d = os.path.join(current_dir, 'config_machine_specific.yaml')
    with open(d, 'r') as stream:
        config.update(yaml.safe_load(stream))
    return SimpleNamespace(**config)
