import inspect
import os
from types import SimpleNamespace

import yaml

current_dir = os.path.dirname(
    os.path.abspath(inspect.getfile(inspect.currentframe())))


def get_args(dataset_name):
    dir_ = os.path.join(current_dir, dataset_name, 'args.yaml')
    with open(dir_, 'r') as stream:
        args = yaml.safe_load(stream)
    args = SimpleNamespace(**args)
    return args
