from evaluation.synthetic.multimodal_vae_moe.evaluator import SyntheticMultimodalMoeEvaluator
from evaluation.synthetic.multimodal_vae_poe.evaluator import SyntheticMultimodalPoeEvaluator


def get_synthetic_evaluator(method_name):
    if method_name == 'multimodal_vae_poe':
        evaluator = SyntheticMultimodalPoeEvaluator
    elif method_name == 'multimodal_vae_moe':
        evaluator = SyntheticMultimodalMoeEvaluator
    else:
        raise ValueError(f'"{method_name}" is illegal method name.')
    return evaluator
