from vae.layers.convolution import ConvBlock, ConvTransposedBlock, DeepConvBlock
from vae.layers.dense import DenseBlock, DenseBlockCategorical
from vae.layers.misc import UpsampleSpatialDimensions


def get_layer(input_shape, specs, generic_layer):
    if specs['t'] == 'conv':
        layer = ConvBlock(input_shape, specs, **generic_layer)
    elif specs['t'] == 'convt':
        layer = ConvTransposedBlock(input_shape, specs, **generic_layer)
    elif specs['t'] == 'dense':
        layer = DenseBlock(input_shape, specs, **generic_layer)
    elif specs['t'] == 'dense_cat':
        layer = DenseBlockCategorical(input_shape, specs, **generic_layer)
    elif specs['t'] == 'dconv':
        layer = DeepConvBlock(input_shape, specs)
    elif specs['t'] == 'usd':
        layer = UpsampleSpatialDimensions(input_shape)
    else:
        raise NotImplementedError('Type not supported')
    return layer
