def preprocess_flowers_data(data, average=True):
    """
    :param average: whether to average over sentence embeddings for each image
    """
    data = _standardization_wrapper(data)
    if average:
        data['caption_features'] = data['caption_features'].mean(1)
    return data


def _standardization_wrapper(data):
    features = []
    if 'image_features' in data.keys():
        features.append('image_features')
    if 'caption_features' in data.keys():
        features.append('caption_features')
    for f in features:
        data[f] = _standardization(data[f], data['loc'])
    return data


def _standardization(x, loc):
    """
    Standardize data as reconstruction likelihoods are Gaussian.
    """
    # means/std over images and captions for each image
    tr = x[loc['train']]
    tr = tr.view(-1, tr.size(-1))
    mean = tr.mean(0)
    std = tr.std(0)

    return (x - mean) / std
