clear all
close all

load simul_kappa_2.mat;

lnpr = 1:2000:50001;

figure;
h1 = errorbar(lnpr,mean(R_passive(:,lnpr)),1.96*std(R_passive(:,lnpr))/sqrt(R),'r--');
hold on
h2 = errorbar(lnpr,mean(R_active(:,lnpr)),1.96*std(R_active(:,lnpr))/sqrt(R),'b');
set(h1,'LineWidth',1.3); set(h2,'LineWidth',1.3);
leg = legend('Full information','Label efficient');
set(leg,'interpreter','latex', 'fontsize', 13)
axis([1 50000 0 200]);
title('Expected regret  ($\kappa=2$)','interpreter','latex', 'fontsize', 14)
xlabel('$t$','interpreter','latex', 'fontsize', 13);
ylabel('$E[R_t]$','interpreter','latex','fontsize', 13);

%%

figure;
h=errorbar(lnpr,mean(samples(:,lnpr)),1.96*std(samples(:,lnpr))/sqrt(R),'b');
set(h,'LineWidth',1.3);
axis([1 50000 0 8000]);
title('Expected sample complexity  ($\kappa=2$)','interpreter','latex','fontsize', 14)
xlabel('$t$','interpreter','latex','fontsize', 13);ylabel('$E[S_t]$','interpreter','latex','fontsize', 13);

%%
lgpr = [1:10:100, 1001:2000:50001];

figure;
plot(mean(samples(:,lgpr)),mean(R_active(:,lgpr))./lgpr,'b','LineWidth',2); hold on%,1.96*std(R_active(:,lgpr))./lgpr/sqrt(R),
plot(lgpr,mean(R_passive(:,lgpr))./lgpr,'r--','LineWidth',2);%1.96*std(R_passive(:,lgpr))./lgpr/sqrt(R),
plot(lgpr,lgpr.^(-kappa/(2*kappa-1))/n^(-kappa/(2*kappa-1))*mean(R_passive(:,n))/n,'r:','LineWidth',1.5);
plot(lgpr,(lgpr).^(-kappa/(2*kappa-2))/max(mean(samples(:,lgpr)))^(-kappa/(2*kappa-2))*mean(R_active(:,n))/n,'b:','LineWidth',1.5);
set(gca, 'XScale','log', 'YScale','log')
leg = legend('Label efficient','Full information');
set(leg, 'interpreter', 'latex', 'fontsize', 13)
axis([1 50000 0.001 0.2]);
title('Normalized regret vs. expected label complexity ($\kappa=2$)', 'interpreter', 'latex', 'fontsize', 14);
xlabel('$E[S_t]$','interpreter','latex','fontsize', 13);
ylabel('$E[R_t]/t$','interpreter','latex','fontsize', 13);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%

clear all

load simul_kappa_1.5.mat;

lnpr = 1:2000:50001;

figure;
h1 = errorbar(lnpr,mean(R_passive(:,lnpr)),1.96*std(R_passive(:,lnpr))/sqrt(R),'r--');
hold on
h2 = errorbar(lnpr,mean(R_active(:,lnpr)),1.96*std(R_active(:,lnpr))/sqrt(R),'b');
set(h1,'LineWidth',1.3); set(h2,'LineWidth',1.3);
leg = legend('Full information','Label efficient');
set(leg,'interpreter','latex', 'fontsize', 13)
axis([1 50000 0 200]);
title('Expected regret  ($\kappa=2$)','interpreter','latex', 'fontsize', 14)
xlabel('$t$','interpreter','latex', 'fontsize', 13);
ylabel('$E[R_t]$','interpreter','latex','fontsize', 13);

%%

figure;
h=errorbar(lnpr,mean(samples(:,lnpr)),1.96*std(samples(:,lnpr))/sqrt(R),'b');
set(h,'LineWidth',1.3);
axis([1 50000 0 8000]);
title('Expected sample complexity  ($\kappa=2$)','interpreter','latex','fontsize', 14)
xlabel('$t$','interpreter','latex','fontsize', 13);ylabel('$E[S_t]$','interpreter','latex','fontsize', 13);

%%
lgpr = [1:10:100, 1001:2000:50001];

figure;
plot(mean(samples(:,lgpr)),mean(R_active(:,lgpr))./lgpr,'b','LineWidth',2); hold on%,1.96*std(R_active(:,lgpr))./lgpr/sqrt(R),
plot(lgpr,mean(R_passive(:,lgpr))./lgpr,'r--','LineWidth',2);%1.96*std(R_passive(:,lgpr))./lgpr/sqrt(R),
plot(lgpr,lgpr.^(-kappa/(2*kappa-1))/n^(-kappa/(2*kappa-1))*mean(R_passive(:,n))/n,'r:','LineWidth',1.5);
plot(lgpr,(lgpr).^(-kappa/(2*kappa-2))/max(mean(samples(:,lgpr)))^(-kappa/(2*kappa-2))*mean(R_active(:,n))/n,'b:','LineWidth',1.5);
set(gca, 'XScale','log', 'YScale','log')
leg = legend('Label efficient','Full information');
set(leg, 'interpreter', 'latex', 'fontsize', 13)
axis([1 50000 0.001 0.2]);
title('Normalized regret vs. expected label complexity ($\kappa=2$)', 'interpreter', 'latex', 'fontsize', 14);
xlabel('$E[S_t]$','interpreter','latex','fontsize', 13);
ylabel('$E[R_t]/t$','interpreter','latex','fontsize', 13);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%