
clear all

%Set the random number generation seed to default, to ensure exact
%reproducibility of the results
rng('default');

% First run experiments for kappa = 1.5
kappa = 1.5:

%time horizon
n=50001;

%number of experts
N=ceil(sqrt(n))*0+225;

%number of repeats
R=500;

R_active=zeros(R,n);
R_passive=zeros(R,n);
L_optimal=zeros(R,n);

samples=zeros(R,n);

for k=1:R;

    %generate features and labels
    x=rand(1,n);
    y=(rand(1,n)<=regression(x));

    %Experts as threshold classifiers
    f=(ones(N,1)*x)>(((0:N-1)'/(N-1))*ones(1,n));

    %Learning rate optimizing worst-case regret bound
    eta=sqrt(8*log(N)/n);

    %log-weight vectors for label efficient and standard forecaster
    lW_active=-log(N)+zeros(1,N);
    lW_passive=-log(N)+zeros(1,N);

    %Forecasts
    haty_active=zeros(1,n);
    haty_passive=zeros(1,n);

    %q and p vectors
    p_active=zeros(1,n);
    p_passive=zeros(1,n);
    q=zeros(1,n);

    %Z vector
    Z=zeros(1,n);

    for t=1:n;
	%weighted proportion of experts predicting label 1
        A1_active=exp(lW_active)*f(:,t)/sum(exp(lW_active));

        %compute sampling probability based on upper bound
        q(t)=min(4*A1_active*(1-A1_active)+eta/3,1);

	%issue prediction and decide whether or not to observe label
        p_active(t)=A1_active;
        haty_active(t)=(rand(1)<=A1_active);
        Z(t)=(rand(1)<=q(t));
        if Z(t)==1;
            lW_active(f(:,t)~=y(t))=lW_active(f(:,t)~=y(t))-eta/q(t);
            lW_active=lW_active-log(sum(exp(lW_active)));
        end;

	%prediction for full-information forecaster
        A1_passive=exp(lW_passive)*f(:,t)/sum(exp(lW_passive));

        p_passive(t)=A1_passive;
        haty_passive(t)=(rand(1)<=A1_passive);
        lW_passive(f(:,t)~=y(t))=lW_passive(f(:,t)~=y(t))-eta;
        lW_passive=lW_passive-log(sum(exp(lW_passive)));
    end;

    %compute optimal predictions, regrets, and observed number of labels
    optimal_pred=(x>=0.5);

    R_active(k,:)=cumsum((haty_active~=y)-(optimal_pred~=y));
    R_passive(k,:)=cumsum((haty_passive~=y)-(optimal_pred~=y));
    L_optimal(k,:)=cumsum(optimal_pred~=y);
    samples(k,:)=cumsum(Z);

end

save simul_kappa_1.5.mat;


%clear all variables and repeat experiments for kappa = 2

clear all
rng('default');

kappa = 2:

%time horizon
n=50001;

%number of experts
N=ceil(sqrt(n))*0+225;

%number of repeats
R=500;

R_active=zeros(R,n);
R_passive=zeros(R,n);
L_optimal=zeros(R,n);

samples=zeros(R,n);

for k=1:R;

    %generate features and labels
    x=rand(1,n);
    y=(rand(1,n)<=regression(x));

    %Experts as threshold classifiers
    f=(ones(N,1)*x)>(((0:N-1)'/(N-1))*ones(1,n));

    %Learning rate optimizing worst-case regret bound
    eta=sqrt(8*log(N)/n);

    %log-weight vectors for label efficient and standard forecaster
    lW_active=-log(N)+zeros(1,N);
    lW_passive=-log(N)+zeros(1,N);

    %Forecasts
    haty_active=zeros(1,n);
    haty_passive=zeros(1,n);

    %q and p vectors
    p_active=zeros(1,n);
    p_passive=zeros(1,n);
    q=zeros(1,n);

    %Z vector
    Z=zeros(1,n);

    for t=1:n;
	%weighted proportion of experts predicting label 1
        A1_active=exp(lW_active)*f(:,t)/sum(exp(lW_active));

        %compute sampling probability based on upper bound
        q(t)=min(4*A1_active*(1-A1_active)+eta/3,1);

	%issue prediction and decide whether or not to observe label
        p_active(t)=A1_active;
        haty_active(t)=(rand(1)<=A1_active);
        Z(t)=(rand(1)<=q(t));
        if Z(t)==1;
            lW_active(f(:,t)~=y(t))=lW_active(f(:,t)~=y(t))-eta/q(t);
            lW_active=lW_active-log(sum(exp(lW_active)));
        end;

	%prediction for full-information forecaster
        A1_passive=exp(lW_passive)*f(:,t)/sum(exp(lW_passive));

        p_passive(t)=A1_passive;
        haty_passive(t)=(rand(1)<=A1_passive);
        lW_passive(f(:,t)~=y(t))=lW_passive(f(:,t)~=y(t))-eta;
        lW_passive=lW_passive-log(sum(exp(lW_passive)));
    end;

    %compute optimal predictions, regrets, and observed number of labels
    optimal_pred=(x>=0.5);

    R_active(k,:)=cumsum((haty_active~=y)-(optimal_pred~=y));
    R_passive(k,:)=cumsum((haty_passive~=y)-(optimal_pred~=y));
    L_optimal(k,:)=cumsum(optimal_pred~=y);
    samples(k,:)=cumsum(Z);

end

save simul_kappa_2.mat;
