% Extract data for kappa = 1.5

clear all

load simul_kappa_1.5;

R_passive_mean = mean(R_passive);
R_active_mean = mean(R_active);
samples_mean = mean(samples);
fig1k15s = [(1:n); R_passive_mean; 1.96*std(R_passive)/sqrt(R); R_active_mean; 1.96*std(R_active)/sqrt(R)]';
fig2k15s = [1:n; mean(samples); 1.96*std(samples)/sqrt(R)]';
fig3k15s = [mean(samples); 1.96*std(samples)/sqrt(R); R_active_mean./(1:n); (1.96*std(R_active)/sqrt(R))./(1:n); 1:n; R_passive_mean./(1:n); (1.96*std(R_passive)/sqrt(R))./(1:n); 
    (1:n).^(-kappa/(2*kappa-1))/n^(-kappa/(2*kappa-1))*R_passive_mean(n)/n; 
    (1:n).^(-kappa/(2*kappa-2))/max(samples_mean)^(-kappa/(2*kappa-2))*R_active_mean(n)/n]';
writematrix(fig1k15s(1:500:50001, :),'fig1k15s','Delimiter','tab')
writematrix(fig2k15s(1:500:50001, :),'fig2k15s','Delimiter','tab')
writematrix(fig3k15s([1:1000, 1001:500:50001], :),'fig3k15s','Delimiter','tab')

% Extract data for kappa = 2

clear all

load simul_kappa_2;

R_passive_mean = mean(R_passive);
R_active_mean = mean(R_active);
samples_mean = mean(samples);
fig1k2s = [(1:n); R_passive_mean; 1.96*std(R_passive)/sqrt(R); R_active_mean; 1.96*std(R_active)/sqrt(R)]';
fig2k2s = [1:n; mean(samples); 1.96*std(samples)/sqrt(R)]';
fig3k2s = [mean(samples); 1.96*std(samples)/sqrt(R); R_active_mean./(1:n); (1.96*std(R_active)/sqrt(R))./(1:n); 1:n; R_passive_mean./(1:n); (1.96*std(R_passive)/sqrt(R))./(1:n); 
    (1:n).^(-kappa/(2*kappa-1))/n^(-kappa/(2*kappa-1))*R_passive_mean(n)/n; 
    (1:n).^(-kappa/(2*kappa-2))/max(samples_mean)^(-kappa/(2*kappa-2))*R_active_mean(n)/n]';
writematrix(fig1k2s(1:500:50001, :),'fig1k2s','Delimiter','tab')
writematrix(fig2k2s(1:500:50001, :),'fig2k2s','Delimiter','tab')
writematrix(fig3k2s([1:1000, 1001:500:50001], :),'fig3k2s','Delimiter','tab')
