import os
import glob

import numpy as np
import pandas as pd
from sklearn.metrics import mean_absolute_percentage_error, mean_absolute_error, mean_squared_error

from data.DataPrepare import load_and_prep_df

_, test = load_and_prep_df()
df_errors = pd.DataFrame()

name_replacements = {}
results_folder = 'results'
for d in os.listdir(results_folder):
    for f in glob.glob(os.path.join(results_folder, d, '(*).csv')):
        df = pd.read_csv(f)
        poi_names = df.columns[1:]
        y_hat = df[poi_names].values
        y = test['venues'][poi_names].values
        df_errors.loc[f, 'rmse'] = mean_squared_error(y_hat, y, squared=False)#, multioutput='raw_values')
        df_errors.loc[f, 'mae'] = mean_absolute_error(y_hat, y)
        df_errors.loc[f, 'mape']  = mean_absolute_percentage_error(y_hat, y)

print(df_errors.to_string())

df_errors.to_csv('results/results.csv')
