import argparse
import json

import dask.dataframe as dd
import osmnx as ox
from dask.diagnostics import ProgressBar
from osmnx import settings

ProgressBar().register()

parser = argparse.ArgumentParser()
parser.add_argument("--near_file", type=str, default='near_test.tsv')

args = parser.parse_args()

ox.settings.log_console = True
ox.settings.use_cache = True

with open('bbox.json') as f:
    bbox = json.load(f)

near_df = dd.read_csv(args.near_file, sep='\t')
#near_df = near_df[(2017 <= dd.to_datetime(near_df.Date).dt.year) & (dd.to_datetime(near_df.Date).dt.year <= 2019)]
near_df = near_df.query(f'{bbox["west"]} <= `Lon of Visit` <= {bbox["east"]}')
near_df = near_df.query(f'{bbox["south"]} <= `Lat of Visit` <= {bbox["north"]}')
near_df = near_df.assign(timestep=dd.to_datetime(near_df['Date'] + ' ' + near_df['Time of Day']).dt.floor('h'))

# FIXME No write access to data folder
# Could use os.path.dirname(args.near_file) +
out_filename = "../data/near_filtered_salzburg"
near_df.to_parquet(out_filename)
print("finished writing " + out_filename)
