# Dirichlet-based Uncertainty Calibration for Active Domain Adaptation

PyTorch Implementation of "Dirichlet-based Uncertainty Calibration for Active Domain Adaptation"

## Requirements
* `NVIDIA GeForce RTX 2080 Ti GPU`
* `CUDA 11.4`
* `python 3.6`
* `torch == 1.7.0`
* `torchvision == 0.8.1`
* `PIL == 8.4.0`


## Datasets

The data folder should be structured as follows:
```
├── data/
│   ├── office-home-65/     
|   |   ├── Art/
|   |   ├── Clipart/
|   |   ├── Product/
|   |   ├── RealWorld/
│   └──	DomainNet/
|   |   |__ clipart/
|   |   |__ painting/
|   |   |__ real/
|   |   |__ sketch/
```

### Office-Home
Office-Home dataset can be found [here](http://hemanthdv.org/OfficeHome-Dataset/).

### miniDomainNet
You need to download the DomainNet dataset first.
(DomainNet dataset can be found [here](http://ai.bu.edu/M3SDA/)).
Then the split files of miniDomainNet can be downloaded [here](https://drive.google.com/file/d/15rrLDCrzyi6ZY-1vJar3u7plgLe4COL7/view).


## Training

Train on miniDomainNet with ResNet-50
```
python3 train.py --cfg configs/minidomainnet.yaml GPU_ID 6 TRAINER.Beta 1.0 TRAINER.Lambda 0.05 SEED 2 TRAINER.MAX_EPOCHS 50 OPTIM.LR 0.002 TRAINER.Kappa 10
```

Train on Office-Home with ResNet-50
```
python3 train.py --cfg configs/home.yaml GPU_ID 6 TRAINER.Beta 1.0 TRAINER.Lambda 0.05 SEED 2 TRAINER.MAX_EPOCHS 50 OPTIM.LR 0.004 TRAINER.Kappa 10
```

## Evaluating
evaluate on Office-Home
```
python3 test.py --cfg configs/home.yaml --source Art --target Clipart --weight_path None GPU_ID 6
```
If "weight_path" is None, then the default path of model weights is used.

