import subprocess, json, heapq
import numpy as np

def best_gamg(n, dataname):
    fileA = '/home/wh_linux/{}/A_{}_{}.dat'.format(dataname, n%60 + 1, n//60 + 1)
    fileb = '/home/wh_linux/{}/b_{}_{}.dat'.format(dataname, n%60 + 1, n//60 + 1)
    cmd = ['./e', '-file_A', fileA, '-file_b', fileb, '-pc_gamg_threshold']
    diverged = 0
    cmd_run = cmd.copy()
    cmd_run.append('1')
    result = subprocess.run(cmd_run, capture_output=True, text=True)
    if int(result.stdout.split()[7]) < 0:
        diverged = diverged+1
    rcond = float(result.stdout.split()[6])
    rconds = []
    pars = np.arange(0, 1, 0.01)
    for i in range(len(pars)):
        cmd_run = cmd.copy()
        cmd_run.append(str(pars[i]))
        result = subprocess.run(cmd_run, capture_output=True, text=True)
        if int(result.stdout.split()[7]) < 0:
            diverged = diverged+1
        if i >= 5 and diverged == i+2:
            return -1
        elif i >= 20 and diverged/i >= 0.9:
            return -1
        rcond_run = float(result.stdout.split()[6])
        if abs(rcond_run - rcond) < 1e-3:
            rconds.append(rcond_run)
            break
        rconds.append(rcond_run)
    smallest_5 = heapq.nsmallest(5, rconds)
    positions = [i for i in range(len(rconds)) if rconds[i] in smallest_5]
    pars_p = []
    rconds_p = []
    for i in positions:
        if i == 0:
            pars_p = pars_p + [0, 0.001, 0.002, 0.003, 0.004]
        elif i == len(pars):
            pars_p = pars_p + [0.996, 0.997, 0.998, 0.999, 1]
        else:
            pars_p = pars_p + np.arange(pars[i]-0.005, pars[i]+0.005, 0.001).tolist()
    for par in pars_p:
        cmd_run = cmd.copy()
        cmd_run.append(str(par))
        result = subprocess.run(cmd_run, capture_output=True, text=True)
        rcond_run = float(result.stdout.split()[6])
        if abs(rcond_run - rcond) < 1e-3:
            rconds_p.append(rcond_run)
            break
        rconds_p.append(rcond_run)
    return pars_p[np.argmin(np.array(rconds_p))]

dataname = 'Bih4225'
X = []
y = []
for i in range(1400, 1500):
    print(i)
    par_best = best_gamg(i, dataname)
    if par_best == -1:
        continue
    X.append([i%60 +1, i//60 +1])
    y.append(par_best)
    
with open('X_2.json', 'w') as f:
    json.dump(X, f)
with open('y_2.json', 'w') as f:
    json.dump(y, f)
