# Code

The core code framework in this folder is as follows:
- `e.c`: Solving equations using PETSc.
- `generate.py`: Solving the optimal parameters using the grid method and save them as json files.
- `speed.py`: Measure speed or calculate other baselines and save them as json files.
- `calculate.ipynb`: Calculate the value of formulas in csv files.
- `compare.ipynb`: Compare the baselines of different algorithms and draw a simple line chart.

The preconditioning methods and PDEs corresponding to the subfolders in this folder are as follows:
- `Bihar`: SOR preconditioning of the Biharmonic equation.
- `old/chebyshev`: SOR preconditioning of the Darcy Flow equation.
- `ssor`: SSOR preconditioning of the Darcy Flow equation.
- `amg`: AMG preconditioning of the Darcy Flow equation.
- `old/sor`: SOR preconditioning of the Second-order Elliptic equation.
- `old/ssor`: SSOR preconditioning of the Second-order Elliptic equation.
- `old/amg`: AMG preconditioning of the Second-order Elliptic equation.

# Runing

To run `e.c`, you can find the command line code you need in the run function in the `generate.py` file in the same directory, in the run function in `custom.py` in the main directory, or simply run 

```bash
./e -pc_type your-preconditioning -pc_your-preconditioning_your-preconditioning-parameter your-parameter
```

# Other Code

The files mentioned below are auxiliary script files or test files:
- `draw(2).ipynb`: Draw line graphs or bar graphs.
- `rename.ipynb`: Rename files.
- `move.ipynb`: Move files.
- `combine.ipynb`: Merge files.
- `copy.ipynb`: Batch copy a file to multiple folders.
- `deleta.ipynb`: Delete files.
- `custom.py`: Custom files store some commonly used custom functions.
- `run.py`, `test.ipynb`, etc.: Test files.

The following files are files that test the pros and cons of neural networks and symbolic regression in our tasks:
- `torch.ipynb`: A simple neural network built using PyTorch.
- `load.ipynb`: Read the constructed neural network and save them as json files.
- `speed_torch.py`: Measure speed of neural network data or calculate other baselines and save them as json files.
