import subprocess, json, sys, os
import numpy as np
sys.path.append('/home/wh_linux/')
import sor.custom as cus
from numbers import Number

source_folder = '/home/wh_linux/sor/amg/3'

def run(var, tol=1e-5, size=102):
    cmd = ['./e', '-pc_type', 'gamg', '-pc_gamg_threshold', str(var), '-ksp_rtol', str(tol), '-size', str((size-2) ** 2)]
    out = []
    print(cmd)
    result = subprocess.run(cmd, capture_output=True, text=True)
    out.append(float(result.stdout.split()[6]))
    return out

def get_its(X, y, tol=1e-5, size=102):
    its = []
    if isinstance(y, Number):
        for i in range(len(X)):
            A = cus.build_chebyshev(4, size, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            its.append(run(y, tol=tol, size=size))
            print(i)
    else:
        for i in range(len(X)):
            it = []
            A = cus.build_chebyshev(4, size, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            if y[i]>=0 and y[i]<=1:
                try:
                    it = run(y[i], tol=tol, size=size)
                except:
                    its.append('error')
                its.append(it)
            else:
                try:
                    it = run(0.0, tol=tol, size=size)
                except:
                    its.append('error')
                its.append(it)
            print(i)
    return its

def get_its_none(X, tol=1e-5, size=102):
    its = []
    for i in range(len(X)):
        A = cus.build_chebyshev(4, size, X[i])
        X_0 = cus.build_darcy(A)
        cus.writetobin(X_0)
        result = subprocess.run(['./e', '-pc_type', 'none', '-ksp_rtol', str(tol)], capture_output=True, text=True)
        its.append(float(result.stdout.split()[6]))
        print(i)

with open('/home/wh_linux/sor/amg/X_test.json', 'r') as f:
    X = json.load(f)
X = X[:50]

for i in [0.0001]:
    for j in [500, 1000, 2000]:
        for k in range(1, 11):
            with open('/home/wh_linux/sor/amg/3/y_test_lr{}_batch{}_{}.json'.format(str(i), str(j), str(k)), 'r') as f:
                y = json.load(f)
            y = y[:50]
            its = get_its(X, y, tol=1e-5)
            with open('/home/wh_linux/sor/amg/3/tol_1e-5/its_lr{}_batch{}_{}.json'.format(str(i), str(j), str(k)), 'w') as f:
                json.dump(its, f)
