import subprocess, json, sys, os
import numpy as np
sys.path.append('/home/wh_linux/')
import sor.custom as cus
from numbers import Number

source_folder = '/home/wh_linux/sor/amg'
folder1 = os.path.join(source_folder, 'tol_1e-3')
folder2 = os.path.join(source_folder, 'tol_1e-7')

def run(var, tol=1e-5):
    cmd = ['./e', '-pc_type', 'gamg', '-pc_gamg_threshold', str(var), '-ksp_rtol', str(tol)]
    out = []
    result = subprocess.run(cmd, capture_output=True, text=True)
    out.append(float(result.stdout.split()[6]))
    return out

def get_its(X, y, tol=1e-5):
    its = []
    if isinstance(y, Number):
        for i in range(len(X)):
            A = cus.build_chebyshev(4, 102, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            its.append(run(y, tol=tol))
            print(i)
    else:
        for i in range(len(X)):
            A = cus.build_chebyshev(4, 102, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            if y[i]>=0 and y[i]<=1:
                try:
                    it = run(y[i], tol=tol)
                except:
                    its.append('error')
                its.append(it)
            else:
                try:
                    it = run(0.0, tol=tol)
                except:
                    its.append('error')
                its.append(it)
            print(i)
    return its

def get_its_none(X, tol=1e-5):
    its = []
    for i in range(len(X)):
        A = cus.build_chebyshev(4, 102, X[i])
        X_0 = cus.build_darcy(A)
        cus.writetobin(X_0)
        result = subprocess.run(['./e', '-pc_type', 'none', '-ksp_rtol', str(tol)], capture_output=True, text=True)
        its.append(float(result.stdout.split()[6]))
        print(i)

with open('X_test.json', 'r') as f:
    X = json.load(f)
with open('/home/wh_linux/sor/amg/torch/y_test.json', 'r') as f:
    y = json.load(f)

its = get_its(X, y, tol=1e-5)
with open('/home/wh_linux/sor/amg/tol_1e-5/rcond_torch.json', 'w') as f:
    json.dump(its, f)