import numpy as np
import scipy.sparse as sp

# 创建二元二阶线性椭圆PDE
def build_elliptic(A, B, C, D, E, F, n):
    a_1 = A * n - D * 2
    a_2 = A * n + D * 2
    b = B * (4 * n)
    c_1 = C * n - E * 2
    c_2 = C * n + E * 2
    d = 2 * (A + C) * n + F
    ones = np.ones(n-1)
    zero_ones = np.ones(n)
    zero_ones[0] = 0
    diag_main_main = d * np.ones(n**2)
    diag_main_lower = c_1 * np.concatenate((ones, np.tile(zero_ones, n-1)))
    diag_main_upper = c_2 * np.concatenate((ones, np.tile(zero_ones, n-1)))
    diag_lower_main = a_1 * np.ones(n**2 - n)
    diag_lower_lower = b * np.concatenate((ones, np.tile(zero_ones, n-2)))
    diag_lower_upper = -b * \
        np.concatenate((np.tile(zero_ones, n-1), np.zeros(1)))
    diag_upper_main = a_2 * np.ones(n**2 - n)
    diag_upper_lower = -b * \
        np.concatenate((np.tile(zero_ones, n-1), np.zeros(1)))
    diag_upper_upper = b * np.concatenate((ones, np.tile(zero_ones, n-2)))
    diagss = [diag_lower_lower, diag_lower_main, diag_lower_upper, diag_main_lower,
              diag_main_main, diag_main_upper, diag_upper_lower, diag_upper_main, diag_upper_upper]
    P = sp.diags(diagss, offsets=[-n-1, -n, -n +
                 1, -1, 0, 1, n-1, n, n+1]).tocoo()
    if (d > 1e-5):
        return P
    elif (d < -1e-5):
        return -P
    return None
