import subprocess, json, sys, os
sys.path.append('/home/wh_linux/')
import sor.custom as cus
from numbers import Number

source_folder = '/home/wh_linux/sor/old/sor'
folder1 = os.path.join(source_folder, 'tol_1e-3')
folder2 = os.path.join(source_folder, 'tol_1e-5')
folder3 = os.path.join(source_folder, 'tol_1e-7')

if not os.path.exists(folder1):
    os.makedirs(folder1)
if not os.path.exists(folder2):
    os.makedirs(folder2)
if not os.path.exists(folder3):
    os.makedirs(folder3)

def run(var, tol=1e-5):
    cmd = ['./e', '-pc_type', 'sor', '-pc_sor_omega', str(var), '-ksp_rtol', str(tol)]
    out = []
    result = subprocess.run(cmd, capture_output=True, text=True)
    out.append(float(result.stdout.split()[0]))
    out.append(int(result.stdout.split()[1]))
    return out

def get_its_times(X, y, tol=1e-5):
    its = []
    times = []
    if isinstance(y, Number):
        for i in range(len(X)):
            A = cus.build_elliptic(X[i][0], X[i][1], X[i][2], X[i][3], X[i][4], X[i][5], 200)
            cus.writetobin(A)
            try:
                result = run(y, tol=tol)
            except:
                times.append('error')
                its.append('error')
            times.append(result[0])
            its.append(result[1])
            print(i)
    else:
        for i in range(len(X)):
            A = cus.build_elliptic(X[i][0], X[i][1], X[i][2], X[i][3], X[i][4], X[i][5], 200)
            cus.writetobin(A)
            if y[i]>=0 and y[i]<=2:
                try:
                    result = run(y[i], tol=tol)
                except:
                    times.append('error')
                    its.append('error')
                times.append(result[0])
                its.append(result[1])
            else:
                try:
                    result = run(1.0, tol=tol)
                except:
                    times.append('error')
                    its.append('error')
                times.append(result[0])
                its.append(result[1])
            print(i)
    return its, times

def get_its_none(X, tol=1e-5):
    its = []
    times = []
    for i in range(len(X)):
        A = cus.build_elliptic(X[i][0], X[i][1], X[i][2], X[i][3], X[i][4], X[i][5], 200)
        cus.writetobin(A)
        result = subprocess.run(['./e', '-pc_type', 'none', '-ksp_rtol', str(tol)], capture_output=True, text=True)
        times.append(float(result.stdout.split()[0]))
        its.append(int(result.stdout.split()[1]))
        print(i)
    return its, times

with open('X_test.json', 'r') as f:
    X = json.load(f)
with open('y_test.json', 'r') as f:
    y = json.load(f)

i = 0
pars = [1.7, 1.8, 1.9]

for par in pars:
    its, times = get_its_times(X, par, tol=1e-3)
    with open('{}/tol_1e-3/rcond_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-3/time_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, par, tol=1e-5)
    with open('{}/tol_1e-5/rcond_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-5/time_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, par, tol=1e-7)
    with open('{}/tol_1e-7/rcond_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-7/time_equal_{}.json'.format(source_folder, str(par)), 'w') as f:
        json.dump(times, f)

for i in range(1, 11):
    with open('y_test1_{}.json'.format(str(i)), 'r') as f:
        y_cal = json.load(f)
    its, times = get_its_times(X, y_cal, tol=1e-3)
    with open('{}/tol_1e-3/rcond_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-3/time_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, y_cal, tol=1e-5)
    with open('{}/tol_1e-5/rcond_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-5/time_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, y_cal, tol=1e-7)
    with open('{}/tol_1e-7/rcond_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-7/time_test1_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)
    with open('y_test2_{}.json'.format(str(i)), 'r') as f:
        y_cal = json.load(f)
    its, times = get_its_times(X, y_cal, tol=1e-3)
    with open('{}/tol_1e-3/roncd_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-3/time_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, y_cal, tol=1e-5)
    with open('{}/tol_1e-5/rcond_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-5/time_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)
    its, times = get_its_times(X, y_cal, tol=1e-7)
    with open('{}/tol_1e-7/rcond_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-7/time_test2_{}.json'.format(source_folder, str(i)), 'w') as f:
        json.dump(times, f)

its, times = get_its_times(X, y, tol=1e-3)
with open('{}/tol_1e-3/rcond_best.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-3/time_best.json'.format(source_folder), 'w') as f:
    json.dump(times, f)
its, times = get_its_times(X, y, tol=1e-5)
with open('{}/tol_1e-5/rcond_best.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-5/time_best.json'.format(source_folder), 'w') as f:
    json.dump(times, f)
its, times = get_its_times(X, y, tol=1e-7)
with open('{}/tol_1e-7/rcond_best.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-7/time_best.json'.format(source_folder), 'w') as f:
    json.dump(times, f)
    
its, times = get_its_none(X, tol=1e-3)
with open('{}/tol_1e-3/rcond_none.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-3/time_none.json'.format(source_folder), 'w') as f:
    json.dump(times, f)
its, times = get_its_none(X, tol=1e-5)
with open('{}/tol_1e-5/rcond_none.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-5/time_none.json'.format(source_folder), 'w') as f:
    json.dump(times, f)
its, times = get_its_none(X, tol=1e-7)
with open('{}/tol_1e-7/rcond_none.json'.format(source_folder), 'w') as f:
    json.dump(its, f)
with open('{}/tol_1e-7/time_none.json'.format(source_folder), 'w') as f:
    json.dump(times, f)