import numpy as np
import scipy.sparse as sp
import struct, json, subprocess

def build_elliptic(A, B, C, D, E, F, n):
    a_1 = A * n - D * 2
    a_2 = A * n + D * 2
    b = B * (4 * n)
    c_1 = C * n - E * 2
    c_2 = C * n + E * 2
    d = 2 * (A + C) * n + F / n
    zero_ones = np.array([0] + np.ones(n-1).tolist())
    main_main = d * np.ones(n**2)
    main_lower = c_1 * np.array(np.ones(n-1).tolist() + np.tile(zero_ones, n-1).tolist())
    main_upper = c_2 * np.array(np.ones(n-1).tolist() + np.tile(zero_ones, n-1).tolist())
    lower_main = a_1 * np.ones(n**2 - n)
    lower_lower = b * np.array(np.ones(n-1).tolist() + np.tile(zero_ones, n-2).tolist())
    lower_upper = -b * np.array(np.tile(zero_ones, n-1).tolist() + [0])
    upper_main = a_2 * np.ones(n**2 - n)
    upper_lower = -b * np.array(np.tile(zero_ones, n-1).tolist() + [0])
    upper_upper = b * np.array(np.ones(n-1).tolist() + np.tile(zero_ones, n-2).tolist())
    P = sp.diags([lower_lower, lower_main, lower_upper, main_lower, main_main, main_upper,
                  upper_lower, upper_main, upper_upper],
                  offsets=[-n-1, -n, -n+1, -1, 0, 1, n-1, n, n+1],
                  shape=[n**2, n**2],
                  format='coo')
    return P

def writetobin(A):
    if A.format != 'coo':
        A = A.tocoo()
    with open('A.bin', 'wb') as f:
        for data in [A.nnz, A.shape[0]]:
            f.write(struct.pack('<i', data))
        for data in A.row.tolist():
            f.write(struct.pack('<i', data))
        for data in A.col.tolist():
            f.write(struct.pack('<i', data))
        for data in A.data.tolist():
            f.write(struct.pack('d', data))
    return None

def bestofn(n, X, y):
    cmd = ['./e', '-ksp_max_it', '1000', '-pc_type', 'sor', '-pc_sor_omega']
    its = []
    t = []
    for i in range(len(X)):
        writetobin(build_elliptic(X[i][0], X[i][1], X[i][2], X[i][3], X[i][4], X[i][5], n))
        cmd_copy = cmd.copy()
        cmd_copy.append(str(y[i]))
        result = subprocess.run(cmd_copy, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
        result_np = np.array(result.stdout.split(), dtype=float)
        its.append(result_np[0])
        t.append(result_np[1])
        print(i)
    with open('its.json', 'w') as f:
        json.dump(its, f)
    with open('t.json', 'w') as f:
        json.dump(t, f)

with open('/root/sor/data/data5/X.json', 'r') as f:
    X = json.load(f)

with open('/root/sor/data/data5/y.json', 'r') as f:
    y = json.load(f)

print(bestofn(1000, X, y))