import numpy as np
import json, sys, subprocess, heapq
sys.path.append('/home/wh_linux/')
import sor.custom as cus
from numbers import Number

def run(var):
    cmd = ['./e', '-ksp_max_it', '1000', '-pc_eisenstat_omega', str(var)]
    out = []
    result = subprocess.run(cmd, capture_output=True, text=True)
    try:
        out.append(float(result.stdout.split()[0]))
        out.append(float(result.stdout.split()[1]))
        out.append(float(result.stdout.split()[2]))
        out.append(int(result.stdout.split()[3]))
    except:
        return var
    return out

def judge_ssor(A):
    cus.writetobin(A)
    pars = np.arange(0.05, 2, 0.05)
    its = []
    for par in pars:
        result = run(par)
        if isinstance(result, Number):
            return par+2
        its.append(result[3])
    if min(its) == 1000:
        return -1
    return 1

N = 72 #有限差分边长,实际线性方程组系数矩阵边长是N^2

with open('X.json', 'r') as f:
    X = json.load(f)
#生成系数矩阵，这里参数是随机生成的，如果你希望使用原有数据集里面的参数，请读一下原有的json文件，按顺序六个参数就是A-F
delete = []
for i in range(len(X)):
    k = np.random.rand(16)
    A= cus.build_chebyshev(4, N, X[i])
    X_0 = cus.build_darcy(A)
    omega = judge_ssor(X_0)
    if omega == -1:
        delete.append(X[i])
    print(i)
for x in X:
    X.remove(x)
with open('X_judged.json', 'w') as f:
    json.dump(X, f)