import subprocess, json, sys, os
import numpy as np
sys.path.append('/home/wh_linux/')
import sor.custom as cus
from numbers import Number

source_folder = '/home/wh_linux/sor/ssor'
for i in range(8):
    folder = os.path.join(source_folder, 'tol_1e-{}'.format(str(i+1)))
    if not os.path.exists(folder):
        os.makedirs(folder)


def run(var, tol=1e-5):
    cmd = ['./e', '-pc_type', 'eisenstat',
           '-pc_eisenstat_omega', str(var), '-ksp_rtol', str(tol)]
    out = []
    result = subprocess.run(cmd, capture_output=True, text=True)
    out.append(float(result.stdout.split()[2]))
    out.append(int(result.stdout.split()[3]))
    return out


def get_its_times(X, y, tol=1e-5):
    its = []
    times = []
    result = []
    if isinstance(y, Number):
        for i in range(len(X)):
            A = cus.build_chebyshev(4, 72, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            try:
                result = run(y, tol=tol)
            except:
                times.append('error')
                its.append('error')
            times.append(result[0])
            its.append(result[1])
            print(i)
    else:
        for i in range(len(X)):
            A = cus.build_chebyshev(4, 72, X[i])
            X_0 = cus.build_darcy(A)
            cus.writetobin(X_0)
            if y[i] >= 0 and y[i] <= 2:
                try:
                    result = run(y[i], tol=tol)
                except:
                    times.append('error')
                    its.append('error')
                times.append(result[0])
                its.append(result[1])
            else:
                try:
                    result = run(1.0, tol=tol)
                except:
                    times.append('error')
                    its.append('error')
                times.append(result[0])
                its.append(result[1])
            print(i)
    return its, times

def get_its_none(X, tol=1e-5):
    its = []
    times = []
    for i in range(len(X)):
        A = cus.build_chebyshev(4, 72, X[i])
        X_0 = cus.build_darcy(A)
        cus.writetobin(X_0)
        result = subprocess.run(['./e', '-pc_type', 'none', '-ksp_rtol', str(tol)], capture_output=True, text=True)
        times.append(float(result.stdout.split()[0]))
        its.append(int(result.stdout.split()[1]))
        print(i)
    return its, times

with open('X_test.json', 'r') as f:
    X_0 = json.load(f)
with open('y_test.json', 'r') as f:
    y_0 = json.load(f)
X = X_0[:100]
y = y_0[:100]

i = 0
pars = [0.2, 1.0, 1.8]

for par in pars:
    for i in range(8):
        its, times = get_its_times(X, par, tol='1e-{}'.format(str(i+1)))
        with open('{}/tol_1e-{}/rcond_equal_{}.json'.format(source_folder, str(i+1), str(par)), 'w') as f:
            json.dump(its, f)
        with open('{}/tol_1e-{}/time_equal_{}.json'.format(source_folder, str(i+1), str(par)), 'w') as f:
            json.dump(times, f)

for i in [3, 5]:
    with open('y_test1_{}.json'.format(str(i)), 'r') as f:
        y_cal = json.load(f)
    for j in range(8):
        its, times = get_its_times(X, y_cal, tol='1e-{}'.format(str(j+1)))
        with open('{}/tol_1e-{}/rcond_test1_{}.json'.format(source_folder, str(j+1), str(i)), 'w') as f:
            json.dump(its, f)
        with open('{}/tol_1e-{}/time_test1_{}.json'.format(source_folder, str(j+1), str(i)), 'w') as f:
            json.dump(times, f)

for i in range(8):
    its, times = get_its_times(X, y, tol='1e-{}'.format(str(i+1)))
    with open('{}/tol_1e-{}/rcond_best.json'.format(source_folder, str(i+1)), 'w') as f:
        json.dump(its, f)
    with open('{}/tol_1e-{}/time_best.json'.format(source_folder, str(i+1)), 'w') as f:
        json.dump(times, f)
